/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.gradle.plugin.licenses.tasks;

import com.datadog.gradle.plugin.licenses.DependencyLicensesExtension;
import com.datadog.gradle.plugin.licenses.internal.DependenciesLicenseProvider;
import com.datadog.gradle.plugin.licenses.internal.License;
import com.datadog.gradle.plugin.licenses.internal.ThirdPartyDependency;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J,\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u001c\u0010\u0003\u001a\u00020\u00048AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/datadog/gradle/plugin/licenses/tasks/CheckDependencyLicensesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "extension", "Lcom/datadog/gradle/plugin/licenses/DependencyLicensesExtension;", "getExtension$plugin", "()Lcom/datadog/gradle/plugin/licenses/DependencyLicensesExtension;", "setExtension$plugin", "(Lcom/datadog/gradle/plugin/licenses/DependencyLicensesExtension;)V", "provider", "Lcom/datadog/gradle/plugin/licenses/internal/DependenciesLicenseProvider;", "applyTask", "", "checkMatchingDependencies", "trueDependencies", "", "Lcom/datadog/gradle/plugin/licenses/internal/ThirdPartyDependency;", "testedDependencies", "check", "", "getCsvInputFile", "Ljava/io/File;", "parseCsvFile", "plugin"})
@SourceDebugExtension(value={"SMAP\nCheckDependencyLicensesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckDependencyLicensesTask.kt\ncom/datadog/gradle/plugin/licenses/tasks/CheckDependencyLicensesTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n766#2:136\n857#2,2:137\n1855#2,2:139\n766#2:141\n857#2,2:142\n1855#2,2:144\n766#2:146\n857#2,2:147\n1855#2,2:149\n1855#2:151\n288#2,2:152\n288#2,2:154\n1856#2:156\n*S KotlinDebug\n*F\n+ 1 CheckDependencyLicensesTask.kt\ncom/datadog/gradle/plugin/licenses/tasks/CheckDependencyLicensesTask\n*L\n57#1:136\n57#1:137,2\n58#1:139,2\n62#1:141\n62#1:142,2\n63#1:144,2\n67#1:146\n67#1:147,2\n68#1:149,2\n80#1:151\n81#1:152,2\n84#1:154,2\n80#1:156\n*E\n"})
public class CheckDependencyLicensesTask
extends DefaultTask {
    @NotNull
    private DependencyLicensesExtension extension = new DependencyLicensesExtension(null, false, false, false, 15, null);
    @NotNull
    private final DependenciesLicenseProvider provider = new DependenciesLicenseProvider();

    public CheckDependencyLicensesTask() {
        this.setGroup("datadog");
        this.setDescription("Check all Third Party Licences appear in the csv file");
    }

    @Input
    @NotNull
    public final DependencyLicensesExtension getExtension$plugin() {
        return this.extension;
    }

    public final void setExtension$plugin(@NotNull DependencyLicensesExtension dependencyLicensesExtension) {
        Intrinsics.checkNotNullParameter((Object)dependencyLicensesExtension, (String)"<set-?>");
        this.extension = dependencyLicensesExtension;
    }

    @TaskAction
    public final void applyTask() {
        ThirdPartyDependency it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        List<ThirdPartyDependency> projectDependencies = this.provider.getThirdPartyDependencies(project, this.extension.getTransitiveDependencies(), this.extension.getListDependencyOnce());
        List<ThirdPartyDependency> listedDependencies = this.parseCsvFile();
        this.checkMatchingDependencies(projectDependencies, listedDependencies, "missing");
        if (this.extension.getCheckObsoleteDependencies()) {
            this.checkMatchingDependencies(listedDependencies, projectDependencies, "obsolete");
        }
        Iterable $this$filter$iv = listedDependencies;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (ThirdPartyDependency)element$iv$iv;
            boolean bl = false;
            if (!(it.getLicense() instanceof License.Empty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThirdPartyDependency it2 = (ThirdPartyDependency)element$iv;
            boolean bl = false;
            this.getLogger().warn("License for " + it2.getOrigin() + " is empty");
        }
        $this$filter$iv = listedDependencies;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (ThirdPartyDependency)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getLicense() instanceof License.Raw)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThirdPartyDependency it3 = (ThirdPartyDependency)element$iv;
            boolean bl3 = false;
            this.getLogger().warn("License for " + it3.getOrigin() + " is not valid : " + it3.getLicense());
        }
        $this$filter$iv = listedDependencies;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl3 = $this$filterTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            element$iv$iv = bl3.next();
            it = (ThirdPartyDependency)element$iv$iv;
            boolean bl4 = false;
            if (!Intrinsics.areEqual((Object)it.getCopyright(), (Object)"__")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThirdPartyDependency it4 = (ThirdPartyDependency)element$iv;
            boolean bl5 = false;
            this.getLogger().warn("Copyright for " + it4.getOrigin() + " is missing");
        }
    }

    private final void checkMatchingDependencies(List<ThirdPartyDependency> trueDependencies, List<ThirdPartyDependency> testedDependencies, String check) {
        boolean error = false;
        Iterable $this$forEach$iv = trueDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v1;
            ThirdPartyDependency known;
            ThirdPartyDependency dep;
            block6: {
                Object v0;
                block5: {
                    dep = (ThirdPartyDependency)element$iv;
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = testedDependencies;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        ThirdPartyDependency it = (ThirdPartyDependency)element$iv2;
                        boolean bl2 = false;
                        if (!(it.getComponent() == dep.getComponent() && Intrinsics.areEqual((Object)it.getOrigin(), (Object)dep.getOrigin()))) continue;
                        v0 = element$iv2;
                        break block5;
                    }
                    v0 = null;
                }
                known = v0;
                Iterable $this$firstOrNull$iv = testedDependencies;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv3 : $this$firstOrNull$iv) {
                    ThirdPartyDependency it = (ThirdPartyDependency)element$iv3;
                    boolean bl = false;
                    if (!(it.getComponent() != dep.getComponent() && Intrinsics.areEqual((Object)it.getOrigin(), (Object)dep.getOrigin()))) continue;
                    v1 = element$iv3;
                    break block6;
                }
                v1 = null;
            }
            ThirdPartyDependency knownInOtherComponent = v1;
            if (known == null && knownInOtherComponent == null) {
                error = true;
                this.getLogger().error("- " + check + " dependency in " + this.extension.getCsvFile().getName() + " : " + dep.toCSV());
                continue;
            }
            if (knownInOtherComponent == null) continue;
            this.getLogger().info("- " + dep.getOrigin() + " " + check + " but exists in component " + knownInOtherComponent.getComponent());
        }
        if (error) {
            throw new VerificationException("Some dependencies are missing in " + this.extension.getCsvFile().getName());
        }
    }

    @InputFile
    @NotNull
    public final File getCsvInputFile() {
        return this.extension.getCsvFile();
    }

    private final List<ThirdPartyDependency> parseCsvFile() {
        List result = new ArrayList();
        Ref.BooleanRef firstLineRead = new Ref.BooleanRef();
        FilesKt.forEachLine$default((File)this.extension.getCsvFile(), null, (Function1)((Function1)new Function1<String, Unit>(firstLineRead, (List<ThirdPartyDependency>)result){
            final /* synthetic */ Ref.BooleanRef $firstLineRead;
            final /* synthetic */ List<ThirdPartyDependency> $result;
            {
                this.$firstLineRead = $firstLineRead;
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$firstLineRead.element) {
                    ThirdPartyDependency dependency = ThirdPartyDependency.Companion.fromCSV(it);
                    if (dependency != null) {
                        this.$result.add(dependency);
                    }
                } else {
                    this.$firstLineRead.element = true;
                }
            }
        }), (int)1, null);
        return result;
    }
}

