/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.statsd;

import com.timgroup.statsd.TagsCardinality;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public abstract class Message
implements Comparable<Message> {
    final String aspect;
    final Type type;
    final String[] tags;
    protected boolean done;
    final TagsCardinality tagsCardinality;
    protected static final int HASH_MULTIPLIER = 31;
    protected static final Set<Type> AGGREGATE_SET = EnumSet.of(Type.COUNT, Type.GAUGE, Type.SET);

    protected Message(Type type, TagsCardinality cardinality) {
        this("", type, cardinality, null);
    }

    protected Message(String aspect, Type type, TagsCardinality cardinality, String[] tags) {
        if (cardinality == null) {
            throw new NullPointerException("cardinality");
        }
        this.aspect = aspect == null ? "" : aspect;
        this.type = type;
        this.done = false;
        this.tagsCardinality = cardinality;
        this.tags = tags;
    }

    abstract boolean writeTo(StringBuilder var1, int var2);

    public abstract void aggregate(Message var1);

    public final String getAspect() {
        return this.aspect;
    }

    public final Type getType() {
        return this.type;
    }

    public String[] getTags() {
        return this.tags;
    }

    public TagsCardinality getTagsCardinality() {
        return this.tagsCardinality;
    }

    public boolean canAggregate() {
        return AGGREGATE_SET.contains((Object)this.type);
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean getDone() {
        return this.done;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + this.type.hashCode();
        hash = hash * 31 + this.aspect.hashCode();
        hash = hash * 31 + this.tagsCardinality.hashCode();
        hash = hash * 31 + Arrays.hashCode(this.tags);
        return hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Message) {
            Message msg = (Message)object;
            return Objects.equals(this.getAspect(), msg.getAspect()) && this.getType() == msg.getType() && this.getTagsCardinality().equals((Object)msg.getTagsCardinality()) && Arrays.equals(this.tags, msg.getTags());
        }
        return false;
    }

    @Override
    public int compareTo(Message message) {
        int cmp = this.getType().compareTo(message.getType());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getAspect().compareTo(message.getAspect());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getTagsCardinality().compareTo(message.getTagsCardinality());
        if (cmp != 0) {
            return cmp;
        }
        if (this.tags == null && message.tags == null) {
            return 0;
        }
        if (this.tags == null) {
            return 1;
        }
        if (message.tags == null) {
            return -1;
        }
        if (this.tags.length == message.tags.length) {
            int comparison = 0;
            for (int i = 0; i < this.tags.length && comparison == 0; ++i) {
                comparison = this.tags[i].compareTo(message.tags[i]);
            }
            return comparison;
        }
        return this.tags.length < message.tags.length ? 1 : -1;
    }

    public static enum Type {
        GAUGE("g"),
        COUNT("c"),
        TIME("ms"),
        SET("s"),
        HISTOGRAM("h"),
        DISTRIBUTION("d"),
        EVENT("_e"),
        SERVICE_CHECK("_sc");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

