/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;

class Filter {
    HashMap<String, Object> filter;
    Pattern domainRegex;
    ArrayList<Pattern> beanRegexes = null;
    ArrayList<String> excludeTags = null;
    HashMap<String, String> additionalTags = null;

    public Filter(Object filter) {
        HashMap castFilter = filter != null ? (HashMap)filter : new HashMap();
        this.filter = castFilter;
    }

    public String toString() {
        return this.filter.toString();
    }

    public Set<String> keySet() {
        return this.filter.keySet();
    }

    private static ArrayList<String> toStringArrayList(final Object toCast) {
        try {
            return (ArrayList)toCast;
        }
        catch (ClassCastException e) {
            return new ArrayList<String>(){
                {
                    this.add((String)toCast);
                }
            };
        }
    }

    public ArrayList<String> getBeanNames() {
        if (this.isEmptyBeanName()) {
            return new ArrayList<String>();
        }
        Object beanNames = this.filter.get("bean") != null ? this.filter.get("bean") : this.filter.get("bean_name");
        return Filter.toStringArrayList(beanNames);
    }

    private static ArrayList<Pattern> toPatternArrayList(Object toCast) {
        ArrayList<Pattern> patternArrayList = new ArrayList<Pattern>();
        ArrayList<String> stringArrayList = Filter.toStringArrayList(toCast);
        for (String string : stringArrayList) {
            patternArrayList.add(Pattern.compile(string));
        }
        return patternArrayList;
    }

    public ArrayList<Pattern> getBeanRegexes() {
        if (this.beanRegexes == null) {
            if (this.filter.get("bean_regex") == null) {
                this.beanRegexes = new ArrayList();
            } else {
                Object beanRegexNames = this.filter.get("bean_regex");
                this.beanRegexes = Filter.toPatternArrayList(beanRegexNames);
            }
        }
        return this.beanRegexes;
    }

    public ArrayList<String> getExcludeTags() {
        if (this.excludeTags == null) {
            if (this.filter.get("exclude_tags") == null) {
                this.excludeTags = new ArrayList();
            } else {
                Object exclude_tags = this.filter.get("exclude_tags");
                this.excludeTags = Filter.toStringArrayList(exclude_tags);
            }
        }
        return this.excludeTags;
    }

    public HashMap<String, String> getAdditionalTags() {
        if (this.additionalTags == null) {
            this.additionalTags = this.filter.get("tags") == null ? new HashMap() : (HashMap)this.filter.get("tags");
        }
        return this.additionalTags;
    }

    public String getDomain() {
        return (String)this.filter.get("domain");
    }

    public Pattern getDomainRegex() {
        if (this.filter.get("domain_regex") == null) {
            return null;
        }
        if (this.domainRegex == null) {
            this.domainRegex = Pattern.compile((String)this.filter.get("domain_regex"));
        }
        return this.domainRegex;
    }

    public Object getAttribute() {
        return this.filter.get("attribute");
    }

    public ArrayList<String> getParameterValues(String parameterName) {
        Object beanValues = this.filter.get(parameterName);
        return Filter.toStringArrayList(beanValues);
    }

    public boolean isEmptyBeanName() {
        return this.filter.get("bean") == null && this.filter.get("bean_name") == null;
    }
}

