/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Logger;

public class Connection {
    private static final long CONNECTION_TIMEOUT = 10000L;
    private static final long JMX_TIMEOUT = 20L;
    private static final Logger LOGGER = Logger.getLogger((String)Connection.class.getName());
    private static final ThreadFactory daemonThreadFactory = new DaemonThreadFactory();
    private JMXConnector connector;
    private MBeanServerConnection mbs;
    protected HashMap<String, Object> env;
    protected JMXServiceURL address;

    private static <T extends Throwable> T initCause(T wrapper, Throwable wrapped) {
        wrapper.initCause(wrapped);
        return wrapper;
    }

    public MBeanAttributeInfo[] getAttributesForBean(ObjectName bean_name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return this.mbs.getMBeanInfo(bean_name).getAttributes();
    }

    public Set<ObjectName> queryNames(ObjectName name) throws IOException {
        String scope = name != null ? name.toString() : "*:*";
        LOGGER.debug((Object)("Querying bean names on scope: " + scope));
        return this.mbs.queryNames(name, null);
    }

    protected void createConnection() throws IOException {
        this.env.put("attribute.remote.x.request.waiting.timeout", 10000L);
        this.closeConnector();
        LOGGER.info((Object)("Connecting to: " + this.address));
        this.connector = this.connectWithTimeout(this.address, this.env);
        this.mbs = this.connector.getMBeanServerConnection();
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object o = this.mbs.getAttribute(objectName, attributeName);
        if (o instanceof Attribute) {
            return ((Attribute)o).getValue();
        }
        return o;
    }

    JMXConnector connectWithTimeout(final JMXServiceURL url, final Map<String, Object> env) throws IOException {
        Object result;
        final ArrayBlockingQueue<String> mailbox = new ArrayBlockingQueue<String>(1);
        ExecutorService executor = Executors.newSingleThreadExecutor(daemonThreadFactory);
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    JMXConnector connector = JMXConnectorFactory.connect(url, env);
                    if (!mailbox.offer(connector)) {
                        connector.close();
                    }
                }
                catch (Throwable t) {
                    mailbox.offer(t);
                }
            }
        });
        try {
            result = mailbox.poll(20L, TimeUnit.SECONDS);
            if (result == null && !mailbox.offer("")) {
                result = mailbox.take();
            }
        }
        catch (InterruptedException e) {
            throw Connection.initCause(new InterruptedIOException(e.getMessage()), e);
        }
        finally {
            executor.shutdown();
        }
        if (result == null) {
            LOGGER.warn((Object)("Connection timed out: " + url));
            throw new SocketTimeoutException("Connection timed out: " + url);
        }
        if (result instanceof JMXConnector) {
            return (JMXConnector)result;
        }
        try {
            throw (Throwable)result;
        }
        catch (Throwable e) {
            throw new IOException(e.toString(), e);
        }
    }

    public void closeConnector() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isAlive() {
        if (this.connector == null) {
            return false;
        }
        try {
            this.connector.getConnectionId();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

