/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.AttachApiConnection;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.RemoteConnection;

public class ConnectionFactory {
    private static final Logger LOGGER = Logger.getLogger((String)ConnectionFactory.class.getName());
    public static final String PROCESS_NAME_REGEX = "process_name_regex";
    private static ConnectionFactory connectionFactory = null;

    public static Connection createConnection(LinkedHashMap<String, Object> connectionParams) throws IOException {
        if (connectionParams.get(PROCESS_NAME_REGEX) != null) {
            try {
                Class.forName("com.sun.tools.attach.AttachNotSupportedException");
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Unable to find tools.jar. Are you using a JDK and did you set the pass to tools.jar ?");
            }
            LOGGER.info((Object)"Connecting using Attach API");
            return new AttachApiConnection(connectionParams);
        }
        LOGGER.info((Object)"Connecting using JMX Remote");
        return new RemoteConnection(connectionParams);
    }
}

