/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.util;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;

public class CustomLogger {
    private static final Logger LOGGER = Logger.getLogger((String)CustomLogger.class.getName());
    private static final Multiset<String> messageCount = HashMultiset.create();
    private static final String LOGGER_LAYOUT = "%d | %-5p| %c{1} | %m%n";

    public static void setup(Level level, String logLocation) {
        if (logLocation != null && !"System.err".equals(logLocation) && !"System.out".equals(logLocation)) {
            RollingFileAppender fa = new RollingFileAppender();
            fa.setName("FileLogger");
            fa.setFile(logLocation);
            fa.setMaxFileSize("5MB");
            fa.setMaxBackupIndex(1);
            fa.setLayout((Layout)new PatternLayout(LOGGER_LAYOUT));
            fa.setThreshold((Priority)level);
            fa.setAppend(true);
            fa.activateOptions();
            Logger.getRootLogger().addAppender((Appender)fa);
            LOGGER.info((Object)"File Handler set");
        } else {
            ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new PatternLayout(LOGGER_LAYOUT));
            if (logLocation != null) {
                consoleAppender.setTarget(logLocation);
            }
            consoleAppender.setThreshold((Priority)level);
            Logger.getRootLogger().addAppender((Appender)consoleAppender);
        }
    }

    public static void laconic(Logger logger, Level level, String message, int max) {
        if (messageCount.count((Object)message) <= max) {
            logger.log((Priority)level, (Object)message);
            messageCount.add((Object)message);
        }
    }

    private CustomLogger() {
    }
}

