/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.primitives.Bytes;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.datadog.jmxfetch.AppConfig;
import org.datadog.jmxfetch.HttpClient;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JsonParser;
import org.datadog.jmxfetch.YamlParser;
import org.datadog.jmxfetch.reporter.Reporter;
import org.datadog.jmxfetch.util.CustomLogger;
import org.datadog.jmxfetch.util.FileHelper;

public class App {
    private static final Logger LOGGER = Logger.getLogger((String)App.class.getName());
    private static final String AUTO_DISCOVERY_PREFIX = "AD-";
    public static final String CANNOT_CONNECT_TO_INSTANCE = "Cannot connect to instance ";
    private static final String AD_CONFIG_SEP = "#### AUTO-DISCOVERY ####";
    private static final String AD_LEGACY_CONFIG_SEP = "#### SERVICE-DISCOVERY ####";
    private static final String AD_CONFIG_TERM = "#### AUTO-DISCOVERY TERM ####";
    private static final String AD_LEGACY_CONFIG_TERM = "#### SERVICE-DISCOVERY TERM ####";
    private static final int AD_MAX_NAME_LEN = 80;
    private static final int AD_MAX_MAG_INSTANCES = 4;
    private static int loopCounter;
    private int lastJSONConfigTS;
    private HashMap<String, Object> adJSONConfigs;
    private ConcurrentHashMap<String, YamlParser> configs;
    private ConcurrentHashMap<String, YamlParser> adPipeConfigs = new ConcurrentHashMap();
    private ArrayList<Instance> instances = new ArrayList();
    private LinkedList<Instance> brokenInstances = new LinkedList();
    private AtomicBoolean reinit = new AtomicBoolean(false);
    private AppConfig appConfig;
    private HttpClient client;

    public App(AppConfig appConfig) {
        this.appConfig = appConfig;
        if (appConfig.remoteEnabled()) {
            this.client = new HttpClient(appConfig.getIPCHost(), appConfig.getIPCPort(), false);
        }
        this.configs = this.getConfigs(appConfig);
    }

    public static void main(String[] args) {
        AppConfig config = new AppConfig();
        JCommander jCommander = null;
        try {
            jCommander = new JCommander((Object)config, args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        if (config.isHelp() || config.getAction().equals("help")) {
            jCommander.usage();
            System.exit(0);
        }
        System.exit(App.run(config));
    }

    public static int run(AppConfig config) {
        CustomLogger.setup(Level.toLevel((String)config.getLogLevel()), config.getLogLocation());
        if (!AppConfig.ACTIONS.contains(config.getAction())) {
            LOGGER.fatal((Object)(config.getAction() + " is not in " + AppConfig.ACTIONS + ". Exiting."));
            return 1;
        }
        if (!config.getAction().equals("collect") && !config.isConsoleReporter()) {
            LOGGER.fatal((Object)(config.getAction() + " argument can only be used with the console reporter. Exiting."));
            return 1;
        }
        if (config.getAction().equals("list_jvms")) {
            List<VirtualMachineDescriptor> descriptors = VirtualMachine.list();
            System.out.println("List of JVMs for user " + System.getProperty("user.name"));
            for (VirtualMachineDescriptor descriptor : descriptors) {
                System.out.println("\tJVM id " + descriptor.id() + ": '" + descriptor.displayName() + "'");
            }
            return 0;
        }
        App.attachShutdownHook();
        LOGGER.info((Object)"JMX Fetch has started");
        config.updateStatus();
        App app = new App(config);
        if (!config.getAction().equals("collect")) {
            app.getJSONConfigs();
        }
        app.init(false);
        if (config.getAction().equals("collect")) {
            app.start();
        }
        return 0;
    }

    private static void attachShutdownHook() {
        class ShutdownHook {
            ShutdownHook() {
            }

            public void attachShutDownHook() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        LOGGER.info((Object)"JMXFetch is closing");
                        Enumeration enume = LOGGER.getAllAppenders();
                        while (enume.hasMoreElements()) {
                            Appender h = (Appender)enume.nextElement();
                            h.close();
                        }
                    }
                });
            }
        }
        new ShutdownHook().attachShutDownHook();
    }

    public void setReinit(boolean reinit) {
        this.reinit.set(reinit);
    }

    public static int getLoopCounter() {
        return loopCounter;
    }

    private static void clearInstances(List<Instance> instances) {
        Iterator<Instance> iterator = instances.iterator();
        while (iterator.hasNext()) {
            Instance instance = iterator.next();
            instance.cleanUp();
            iterator.remove();
        }
    }

    private String getAutoDiscoveryName(String config) {
        String[] splitted = config.split(System.getProperty("line.separator"), 2);
        return AUTO_DISCOVERY_PREFIX + splitted[0].substring(2, splitted[0].length());
    }

    private FileInputStream newAutoDiscoveryPipe() {
        FileInputStream adPipe = null;
        String pipeName = this.appConfig.getAutoDiscoveryPipe();
        try {
            adPipe = new FileInputStream(pipeName);
            LOGGER.info((Object)("Named pipe for Auto-Discovery opened: " + pipeName));
        }
        catch (FileNotFoundException e) {
            LOGGER.info((Object)("Unable to open named pipe for Auto-Discovery: " + pipeName));
        }
        return adPipe;
    }

    public boolean processAutoDiscovery(byte[] buffer) {
        String[] discovered;
        boolean reinit = false;
        try {
            String configs = new String(buffer, "UTF-8");
            String separator = AD_CONFIG_SEP;
            if (configs.indexOf(AD_LEGACY_CONFIG_SEP) != -1) {
                separator = AD_LEGACY_CONFIG_SEP;
            }
            discovered = configs.split(separator + System.getProperty("line.separator"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.debug((Object)"Unable to parse byte buffer to UTF-8 String.");
            return false;
        }
        for (String config : discovered) {
            if (config == null || config.isEmpty()) continue;
            try {
                String name = this.getAutoDiscoveryName(config);
                LOGGER.debug((Object)("Attempting to apply config. Name: " + name + "\nconfig: \n" + config));
                ByteArrayInputStream stream = new ByteArrayInputStream(config.getBytes("UTF-8"));
                YamlParser yaml = new YamlParser(stream);
                if (this.addConfig(name, yaml)) {
                    reinit = true;
                    LOGGER.debug((Object)"Configuration added succesfully reinit in order");
                    continue;
                }
                LOGGER.debug((Object)"Unable to apply configuration.");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.debug((Object)"Unable to parse byte buffer to UTF-8 String.");
            }
        }
        return reinit;
    }

    protected ArrayList<Instance> getInstances() {
        return this.instances;
    }

    void start() {
        long start_ms = System.currentTimeMillis();
        long delta_s = 0L;
        FileInputStream adPipe = null;
        if (this.appConfig.getAutoDiscoveryPipeEnabled()) {
            LOGGER.info((Object)"Auto Discovery enabled");
            adPipe = this.newAutoDiscoveryPipe();
            try {
                FileHelper.touch(new File(this.appConfig.getJMXLaunchFile()));
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Unable to create launch file - Auto-Discovery configs will not be automatically resubmitted.");
            }
        }
        while (true) {
            if (this.appConfig.getExitWatcher().shouldExit()) {
                LOGGER.info((Object)"Exit file detected: stopping JMXFetch.");
                return;
            }
            if (adPipe == null && this.appConfig.getAutoDiscoveryPipeEnabled()) {
                adPipe = this.newAutoDiscoveryPipe();
            }
            try {
                if (adPipe != null && adPipe.available() > 0) {
                    byte[] buffer = new byte[]{};
                    boolean terminated = false;
                    while (!terminated) {
                        int len = adPipe.available();
                        if (len <= 0) continue;
                        byte[] minibuff = new byte[len];
                        adPipe.read(minibuff);
                        if (Bytes.indexOf((byte[])minibuff, (byte[])AD_LEGACY_CONFIG_TERM.getBytes()) > -1 || Bytes.indexOf((byte[])minibuff, (byte[])AD_CONFIG_TERM.getBytes()) > -1) {
                            terminated = true;
                        }
                        int oldLen = buffer.length;
                        buffer = Arrays.copyOf(buffer, buffer.length + len);
                        System.arraycopy(minibuff, 0, buffer, oldLen, len);
                    }
                    this.setReinit(this.processAutoDiscovery(buffer));
                }
                if (this.appConfig.remoteEnabled()) {
                    this.setReinit(this.getJSONConfigs());
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)"Unable to read from pipe - Service Discovery configuration may have been skipped.");
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Problem parsing auto-discovery configuration: " + e));
            }
            long start = System.currentTimeMillis();
            if (this.reinit.get()) {
                this.init(true);
            }
            if (this.instances.size() > 0) {
                this.doIteration();
            } else {
                LOGGER.warn((Object)"No instance could be initiated. Retrying initialization.");
                this.appConfig.getStatus().flush();
                this.configs = this.getConfigs(this.appConfig);
                this.init(true);
            }
            long length = System.currentTimeMillis() - start;
            LOGGER.debug((Object)("Iteration ran in " + length + " ms"));
            try {
                int loopPeriod = this.appConfig.getCheckPeriod();
                LOGGER.debug((Object)("Sleeping for " + loopPeriod + " ms."));
                Thread.sleep(loopPeriod);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.warn((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void doIteration() {
        ++loopCounter;
        Reporter reporter = this.appConfig.getReporter();
        for (Instance instance : this.instances) {
            String instanceStatus = "OK";
            String scStatus = "OK";
            String instanceMessage = null;
            int numberOfMetrics = 0;
            try {
                if (!instance.timeToCollect()) {
                    LOGGER.debug((Object)("it is not time to collect, skipping run for " + instance.getName()));
                    continue;
                }
                LinkedList<HashMap<String, Object>> metrics = instance.getMetrics();
                numberOfMetrics = metrics.size();
                if (numberOfMetrics == 0) {
                    instanceMessage = "Instance " + instance + " didn't return any metrics";
                    LOGGER.warn((Object)instanceMessage);
                    instanceStatus = "ERROR";
                    scStatus = "ERROR";
                    this.brokenInstances.add(instance);
                } else if (instance.isLimitReached()) {
                    instanceMessage = "Number of returned metrics is too high for instance: " + instance.getName() + ". Please read http://docs.datadoghq.com/integrations/java/ or get in touch with Datadog Support for more details. Truncating to " + instance.getMaxNumberOfMetrics() + " metrics.";
                    instanceStatus = "WARNING";
                    CustomLogger.laconic(LOGGER, Level.WARN, instanceMessage, 0);
                }
                if (numberOfMetrics > 0) {
                    reporter.sendMetrics(metrics, instance.getName(), instance.getCanonicalRateConfig());
                }
            }
            catch (IOException e) {
                instanceMessage = "Unable to refresh bean list for instance " + instance;
                LOGGER.warn((Object)instanceMessage, (Throwable)e);
                instanceStatus = "ERROR";
                scStatus = "ERROR";
                this.brokenInstances.add(instance);
            }
            this.reportStatus(this.appConfig, reporter, instance, numberOfMetrics, instanceMessage, instanceStatus);
            this.sendServiceCheck(reporter, instance, instanceMessage, scStatus);
        }
        Iterator<Instance> it = this.brokenInstances.iterator();
        while (it.hasNext()) {
            Instance instance;
            instance = it.next();
            reporter.clearRatesAggregator(instance.getName());
            LOGGER.warn((Object)("Instance " + instance + " didn't return any metrics.Maybe the server got disconnected ? Trying to reconnect."));
            instance.cleanUp();
            this.instances.remove(instance);
            Instance newInstance = new Instance(instance, this.appConfig);
            try {
                LOGGER.info((Object)("Trying to reconnect to: " + newInstance));
                newInstance.init(true);
                this.instances.add(newInstance);
                it.remove();
            }
            catch (Exception e) {
                String warning = null;
                if (e instanceof IOException) {
                    warning = CANNOT_CONNECT_TO_INSTANCE + instance + ". Is a JMX Server running at this address?";
                    LOGGER.warn((Object)warning);
                } else if (e instanceof SecurityException) {
                    warning = CANNOT_CONNECT_TO_INSTANCE + instance + " because of bad credentials. Please check your credentials";
                    LOGGER.warn((Object)warning);
                } else if (e instanceof FailedLoginException) {
                    warning = CANNOT_CONNECT_TO_INSTANCE + instance + " because of bad credentials. Please check your credentials";
                    LOGGER.warn((Object)warning);
                } else {
                    warning = CANNOT_CONNECT_TO_INSTANCE + instance + " for an unknown reason." + e.getMessage();
                    LOGGER.fatal((Object)warning, (Throwable)e);
                }
                this.reportStatus(this.appConfig, reporter, instance, 0, warning, "ERROR");
                this.sendServiceCheck(reporter, instance, warning, "ERROR");
            }
        }
        try {
            this.appConfig.getStatus().flush();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to flush stats.", (Throwable)e);
        }
    }

    public boolean addConfig(String name, YamlParser config) {
        if (name.length() > AUTO_DISCOVERY_PREFIX.length() + 80 + 4 + 2) {
            LOGGER.debug((Object)("Name too long - skipping: " + name));
            return false;
        }
        String patternText = "AD-(.{1,80})_(\\d{0,4})";
        Pattern pattern = Pattern.compile(patternText);
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            LOGGER.debug((Object)("Cannot match instance name: " + name));
            return false;
        }
        String check = matcher.group(1);
        if (this.configs.containsKey(check)) {
            LOGGER.debug((Object)("Key already present - skipping: " + name));
            return false;
        }
        this.adPipeConfigs.put(name, config);
        this.setReinit(true);
        return true;
    }

    public boolean addJsonConfig(String name, String json) {
        return false;
    }

    private ConcurrentHashMap<String, YamlParser> getConfigs(AppConfig config) {
        ConcurrentHashMap<String, YamlParser> configs = new ConcurrentHashMap<String, YamlParser>();
        this.loadFileConfigs(config, configs);
        this.loadResourceConfigs(config, configs);
        LOGGER.info((Object)("Found " + configs.size() + " config files"));
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFileConfigs(AppConfig config, ConcurrentHashMap<String, YamlParser> configs) {
        List<String> fileList = config.getYamlFileList();
        if (fileList != null) {
            for (String fileName : fileList) {
                File f = new File(config.getConfdDirectory(), fileName);
                String name = f.getName().replace(".yaml", "");
                String yamlPath = f.getAbsolutePath();
                FileInputStream yamlInputStream = null;
                LOGGER.info((Object)("Reading " + yamlPath));
                try {
                    yamlInputStream = new FileInputStream(yamlPath);
                    configs.put(name, new YamlParser(yamlInputStream));
                }
                catch (FileNotFoundException e) {
                    LOGGER.warn((Object)("Cannot find " + yamlPath));
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Cannot parse yaml file " + yamlPath), (Throwable)e);
                }
                finally {
                    if (yamlInputStream == null) continue;
                    try {
                        yamlInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResourceConfigs(AppConfig config, ConcurrentHashMap<String, YamlParser> configs) {
        List<String> resourceConfigList = config.getInstanceConfigResources();
        if (resourceConfigList != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            for (String resourceName : resourceConfigList) {
                String name = resourceName.replace(".yaml", "");
                LOGGER.info((Object)("Reading " + resourceName));
                InputStream inputStream = classLoader.getResourceAsStream(resourceName);
                if (inputStream == null) {
                    LOGGER.warn((Object)("Cannot find " + resourceName));
                    continue;
                }
                try {
                    configs.put(name, new YamlParser(inputStream));
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Cannot parse yaml file " + resourceName), (Throwable)e);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private boolean getJSONConfigs() {
        boolean update = false;
        if (this.client == null) {
            return update;
        }
        try {
            String uripath = "agent/jmx/configs?timestamp=" + this.lastJSONConfigTS;
            HttpClient.HttpResponse response = this.client.request("GET", "", uripath);
            if (!response.isResponse2xx()) {
                LOGGER.warn((Object)("Failed collecting JSON configs: [" + response.getResponseCode() + "] " + response.getResponseBody()));
                return update;
            }
            if (response.getResponseCode() == 204) {
                LOGGER.debug((Object)"No configuration changes...");
                return update;
            }
            LOGGER.debug((Object)("Received the following JSON configs: " + response.getResponseBody()));
            InputStream jsonInputStream = IOUtils.toInputStream((String)response.getResponseBody(), (String)"UTF-8");
            JsonParser parser = new JsonParser(jsonInputStream);
            int timestamp = (Integer)parser.getJsonTimestamp();
            if (timestamp > this.lastJSONConfigTS) {
                this.adJSONConfigs = (HashMap)parser.getJsonConfigs();
                this.lastJSONConfigTS = timestamp;
                update = true;
                LOGGER.debug((Object)("update is in order - updating timestamp: " + this.lastJSONConfigTS));
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error((Object)("error processing JSON response: " + (Object)((Object)e)));
        }
        catch (IOException e) {
            LOGGER.error((Object)("unable to collect remote JMX configs: " + e));
        }
        return update;
    }

    private void reportStatus(AppConfig appConfig, Reporter reporter, Instance instance, int metricCount, String message, String status) {
        String checkName = instance.getCheckName();
        appConfig.getStatus().addInstanceStats(checkName, instance.getName(), metricCount, reporter.getServiceCheckCount(checkName), message, status);
    }

    private void sendServiceCheck(Reporter reporter, Instance instance, String message, String status) {
        String checkName = instance.getCheckName();
        reporter.sendServiceCheck(checkName, status, message, instance.getServiceCheckTags());
        reporter.resetServiceCheckCount(checkName);
    }

    private void instantiate(LinkedHashMap<String, Object> instanceMap, LinkedHashMap<String, Object> initConfig, String checkName, AppConfig appConfig, boolean forceNewConnection) {
        Instance instance;
        Reporter reporter = appConfig.getReporter();
        try {
            instance = new Instance(instanceMap, initConfig, checkName, appConfig);
        }
        catch (Exception e) {
            String warning = "Unable to create instance. Please check your yaml file";
            appConfig.getStatus().addInitFailedCheck(checkName, warning, "ERROR");
            LOGGER.error((Object)warning, (Throwable)e);
            return;
        }
        try {
            instance.init(forceNewConnection);
            this.instances.add(instance);
        }
        catch (IOException e) {
            instance.cleanUp();
            this.brokenInstances.add(instance);
            String warning = CANNOT_CONNECT_TO_INSTANCE + instance + ". " + e.getMessage();
            this.reportStatus(appConfig, reporter, instance, 0, warning, "ERROR");
            this.sendServiceCheck(reporter, instance, warning, "ERROR");
            LOGGER.error((Object)warning, (Throwable)e);
        }
        catch (Exception e) {
            instance.cleanUp();
            this.brokenInstances.add(instance);
            String warning = "Unexpected exception while initiating instance " + instance + " : " + e.getMessage();
            this.reportStatus(appConfig, reporter, instance, 0, warning, "ERROR");
            this.sendServiceCheck(reporter, instance, warning, "ERROR");
            LOGGER.error((Object)warning, (Throwable)e);
        }
    }

    public void init(boolean forceNewConnection) {
        ArrayList configInstances;
        App.clearInstances(this.instances);
        App.clearInstances(this.brokenInstances);
        Iterator<Map.Entry<String, YamlParser>> it = this.configs.entrySet().iterator();
        Iterator<Map.Entry<String, YamlParser>> itSD = this.adPipeConfigs.entrySet().iterator();
        while (it.hasNext() || itSD.hasNext()) {
            Map.Entry<String, YamlParser> entry;
            boolean sdIterator = false;
            if (it.hasNext()) {
                entry = it.next();
            } else {
                entry = itSD.next();
                sdIterator = true;
            }
            String name = entry.getKey();
            YamlParser yamlConfig = entry.getValue();
            if (!sdIterator) {
                it.remove();
            }
            if ((configInstances = (ArrayList)yamlConfig.getYamlInstances()) == null || configInstances.size() == 0) {
                String warning = "No instance found in :" + name;
                LOGGER.warn((Object)warning);
                this.appConfig.getStatus().addInitFailedCheck(name, warning, "ERROR");
                continue;
            }
            for (LinkedHashMap configInstance : configInstances) {
                this.instantiate(configInstance, (LinkedHashMap)yamlConfig.getInitConfig(), name, this.appConfig, forceNewConnection);
            }
        }
        if (this.adJSONConfigs != null) {
            for (String check : this.adJSONConfigs.keySet()) {
                HashMap checkConfig = (HashMap)this.adJSONConfigs.get(check);
                LinkedHashMap initConfig = (LinkedHashMap)checkConfig.get("init_config");
                configInstances = (ArrayList)checkConfig.get("instances");
                String checkName = (String)checkConfig.get("check_name");
                for (LinkedHashMap configInstance : configInstances) {
                    this.instantiate(configInstance, initConfig, checkName, this.appConfig, forceNewConnection);
                }
            }
        }
    }
}

