/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.datadog.jmxfetch.Filter;
import org.datadog.jmxfetch.JMXAttribute;

public class Configuration {
    private LinkedHashMap<String, Object> conf;
    private Filter include;
    private Filter exclude;

    public Configuration(LinkedHashMap<String, Object> conf) {
        this.conf = conf;
        this.include = new Filter(conf.get("include"));
        this.exclude = new Filter(conf.get("exclude"));
    }

    public LinkedHashMap<String, Object> getConf() {
        return this.conf;
    }

    public Filter getInclude() {
        return this.include;
    }

    public Filter getExclude() {
        return this.exclude;
    }

    public String toString() {
        return "include: " + this.include + " - exclude: " + this.exclude;
    }

    private Boolean hasInclude() {
        return this.getInclude() != null;
    }

    private static LinkedList<Configuration> getIncludeConfigurationList(LinkedList<Configuration> configurationList) {
        LinkedList<Configuration> includeConfigList = new LinkedList<Configuration>(configurationList);
        Iterator confItr = includeConfigList.iterator();
        while (confItr.hasNext()) {
            Configuration conf = (Configuration)confItr.next();
            if (conf.hasInclude().booleanValue()) continue;
            confItr.remove();
        }
        return includeConfigList;
    }

    private static HashMap<String, LinkedList<Filter>> getIncludeFiltersByDomain(LinkedList<Configuration> configurationList) {
        HashMap<String, LinkedList<Filter>> includeFiltersByDomain = new HashMap<String, LinkedList<Filter>>();
        for (Configuration conf : configurationList) {
            Filter filter = conf.getInclude();
            LinkedList<Filter> filters = new LinkedList<Filter>();
            if (!filter.isEmptyBeanName()) {
                ArrayList<String> beanNames = filter.getBeanNames();
                for (String beanName : beanNames) {
                    String[] splitBeanName = beanName.split(":");
                    String domain = splitBeanName[0];
                    String rawBeanParameters = splitBeanName[1];
                    HashMap<String, String> beanParametersHash = JMXAttribute.getBeanParametersHash(rawBeanParameters);
                    beanParametersHash.put("domain", domain);
                    filters.add(new Filter(beanParametersHash));
                }
            } else {
                filters.add(filter);
            }
            for (Filter f : filters) {
                String domainName = f.getDomain();
                LinkedList<Object> domainFilters = includeFiltersByDomain.containsKey(domainName) ? includeFiltersByDomain.get(domainName) : new LinkedList();
                domainFilters.add(f);
                includeFiltersByDomain.put(domainName, domainFilters);
            }
        }
        return includeFiltersByDomain;
    }

    private static HashMap<String, Set<String>> getCommonBeanKeysByDomain(HashMap<String, LinkedList<Filter>> filtersByDomain) {
        HashMap<String, Set<String>> beanKeysIntersectionByDomain = new HashMap<String, Set<String>>();
        for (Map.Entry<String, LinkedList<Filter>> filtersEntry : filtersByDomain.entrySet()) {
            String domainName = filtersEntry.getKey();
            LinkedList<Filter> mFilters = filtersEntry.getValue();
            HashSet<String> keysIntersection = new HashSet<String>(mFilters.getFirst().keySet());
            for (Filter f : mFilters) {
                keysIntersection.retainAll(f.keySet());
            }
            for (String param : JMXAttribute.getExcludedBeanParams()) {
                keysIntersection.remove(param);
            }
            beanKeysIntersectionByDomain.put(domainName, keysIntersection);
        }
        return beanKeysIntersectionByDomain;
    }

    private static HashMap<String, LinkedHashMap<String, String>> getCommonScopeByDomain(HashMap<String, Set<String>> beanKeysByDomain, HashMap<String, LinkedList<Filter>> filtersByDomain) {
        HashMap<String, LinkedHashMap<String, String>> commonScopeByDomain = new HashMap<String, LinkedHashMap<String, String>>();
        for (Map.Entry<String, Set<String>> commonParametersByDomainEntry : beanKeysByDomain.entrySet()) {
            String domainName = commonParametersByDomainEntry.getKey();
            Set<String> commonParameters = commonParametersByDomainEntry.getValue();
            LinkedList<Filter> filters = filtersByDomain.get(domainName);
            LinkedHashMap<String, String> commonScope = new LinkedHashMap<String, String>();
            for (String parameter : commonParameters) {
                String commonValue = null;
                Boolean hasCommonValue = true;
                for (Filter f : filters) {
                    ArrayList<String> parameterValues = f.getParameterValues(parameter);
                    if (parameterValues.size() != 1 || commonValue != null && !commonValue.equals(parameterValues.get(0))) {
                        hasCommonValue = false;
                        break;
                    }
                    commonValue = parameterValues.get(0);
                }
                if (!hasCommonValue.booleanValue()) continue;
                commonScope.put(parameter, commonValue);
            }
            commonScopeByDomain.put(domainName, commonScope);
        }
        return commonScopeByDomain;
    }

    private static String beanScopeToString(String domain, LinkedHashMap<String, String> beanScope) {
        String result = "";
        domain = domain != null ? domain : "*";
        result = result + domain + ":";
        for (Map.Entry<String, String> beanScopeEntry : beanScope.entrySet()) {
            String param = beanScopeEntry.getKey();
            String value = beanScopeEntry.getValue();
            result = result + param + "=" + value + ",";
        }
        result = result + "*";
        return result;
    }

    public static LinkedList<String> getGreatestCommonScopes(LinkedList<Configuration> configurationList) {
        LinkedList<Configuration> includeConfigList = Configuration.getIncludeConfigurationList(configurationList);
        HashMap<String, LinkedList<Filter>> includeFiltersByDomain = Configuration.getIncludeFiltersByDomain(includeConfigList);
        HashMap<String, Set<String>> parametersIntersectionByDomain = Configuration.getCommonBeanKeysByDomain(includeFiltersByDomain);
        HashMap<String, LinkedHashMap<String, String>> commonBeanScopeByDomain = Configuration.getCommonScopeByDomain(parametersIntersectionByDomain, includeFiltersByDomain);
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, LinkedHashMap<String, String>> beanScopeEntry : commonBeanScopeByDomain.entrySet()) {
            String domain = beanScopeEntry.getKey();
            LinkedHashMap<String, String> beanScope = beanScopeEntry.getValue();
            result.add(Configuration.beanScopeToString(domain, beanScope));
        }
        return result;
    }
}

