/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.util.HashMap;
import java.util.LinkedList;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.InstanceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetricCollectionTask
extends InstanceTask<LinkedList<HashMap<String, Object>>> {
    private static final Logger log = LoggerFactory.getLogger(MetricCollectionTask.class);

    MetricCollectionTask(Instance instance) {
        super(instance);
        this.setWarning("Unable to collect metrics or refresh bean list.");
    }

    @Override
    public LinkedList<HashMap<String, Object>> call() throws Exception {
        if (!this.instance.timeToCollect()) {
            log.debug("it is not time to collect, skipping run for instance: " + this.instance.getName());
            return new LinkedList<HashMap<String, Object>>();
        }
        return this.instance.getMetrics();
    }
}

