/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.reporter;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.LinkedList;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JmxAttribute;
import org.datadog.jmxfetch.reporter.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleReporter
extends Reporter {
    private static final Logger log = LoggerFactory.getLogger(ConsoleReporter.class);
    private LinkedList<HashMap<String, Object>> metrics = new LinkedList();
    private LinkedList<HashMap<String, Object>> serviceChecks = new LinkedList();

    @Override
    protected void sendMetricPoint(String metricType, String metricName, double value, String[] tags) {
        String tagString = "[" + Joiner.on((String)",").join((Object[])tags) + "]";
        log.info(metricName + tagString + " - " + System.currentTimeMillis() / 1000L + " = " + value);
        HashMap<String, Object> metric = new HashMap<String, Object>();
        metric.put("name", metricName);
        metric.put("value", value);
        metric.put("tags", tags);
        metric.put("type", metricType);
        this.metrics.add(metric);
    }

    public LinkedList<HashMap<String, Object>> getMetrics() {
        LinkedList<HashMap<String, Object>> returnedMetrics = new LinkedList<HashMap<String, Object>>();
        for (HashMap hashMap : this.metrics) {
            returnedMetrics.add(new HashMap(hashMap));
        }
        this.metrics.clear();
        return returnedMetrics;
    }

    @Override
    public void doSendServiceCheck(String checkName, String status, String message, String[] tags) {
        String tagString = "";
        if (tags != null && tags.length > 0) {
            tagString = "[" + Joiner.on((String)",").join((Object[])tags) + "]";
        }
        log.info(checkName + tagString + " - " + System.currentTimeMillis() / 1000L + " = " + status);
        HashMap<String, Object> sc = new HashMap<String, Object>();
        sc.put("name", checkName);
        sc.put("status", status);
        sc.put("message", message);
        sc.put("tags", tags);
        this.serviceChecks.add(sc);
    }

    public LinkedList<HashMap<String, Object>> getServiceChecks() {
        LinkedList<HashMap<String, Object>> returnedServiceChecks = new LinkedList<HashMap<String, Object>>();
        for (HashMap hashMap : this.serviceChecks) {
            returnedServiceChecks.add(new HashMap(hashMap));
        }
        this.serviceChecks.clear();
        return returnedServiceChecks;
    }

    @Override
    public void displayMetricReached() {
        log.info("       ------- METRIC LIMIT REACHED: ATTRIBUTES BELOW WON'T BE COLLECTED -------");
    }

    @Override
    public void displayMatchingAttributeName(JmxAttribute jmxAttribute, int rank, int limit) {
        log.info("       Matching: " + rank + "/" + limit + ". " + jmxAttribute);
    }

    @Override
    public void displayNonMatchingAttributeName(JmxAttribute jmxAttribute) {
        log.info("       Not Matching: " + jmxAttribute);
    }

    @Override
    public void displayInstanceName(Instance instance) {
        log.info("#####################################");
        log.info("Instance: " + instance);
        log.info("#####################################");
    }
}

