/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch.reporter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.datadog.jmxfetch.App;
import org.datadog.jmxfetch.Instance;
import org.datadog.jmxfetch.JmxAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Reporter {
    private static final Logger log = LoggerFactory.getLogger(Reporter.class);
    public static final String VALUE = "value";
    private HashMap<String, Integer> serviceCheckCount;
    private HashMap<String, HashMap<String, HashMap<String, Object>>> ratesAggregator = new HashMap();
    private HashMap<String, HashMap<String, Long>> countersAggregator = new HashMap();

    public Reporter() {
        this.serviceCheckCount = new HashMap();
    }

    String generateId(HashMap<String, Object> metric) {
        String key = (String)metric.get("alias");
        for (String tag : (String[])metric.get("tags")) {
            key = key + tag;
        }
        return key;
    }

    public void clearRatesAggregator(String instanceName) {
        this.ratesAggregator.put(instanceName, new HashMap());
    }

    public void clearCountersAggregator(String instanceName) {
        this.countersAggregator.put(instanceName, new HashMap());
    }

    public void sendMetrics(LinkedList<HashMap<String, Object>> metrics, String instanceName, boolean canonicalRate) {
        HashMap<Object, Object> instanceRatesAggregator = this.ratesAggregator.containsKey(instanceName) ? this.ratesAggregator.get(instanceName) : new HashMap();
        HashMap<Object, Object> instanceCountersAggregator = this.countersAggregator.containsKey(instanceName) ? this.countersAggregator.get(instanceName) : new HashMap();
        int loopCounter = App.getLoopCounter();
        String sendingMessage = "Instance " + instanceName + " is sending " + metrics.size() + " metrics to the metrics reporter during collection #" + loopCounter;
        if (loopCounter <= 5 || loopCounter % 10 == 0) {
            log.info(sendingMessage);
            if (loopCounter == 5) {
                log.info("Next collections will be logged only every 10 collections.");
            }
        } else {
            log.debug(sendingMessage);
        }
        for (HashMap hashMap : metrics) {
            boolean submit;
            String key;
            HashMap<String, Object> metric = new HashMap<String, Object>(hashMap);
            Double currentValue = (Double)metric.get(VALUE);
            if (currentValue.isNaN() || currentValue.isInfinite()) continue;
            String metricName = (String)metric.get("alias");
            String metricType = (String)metric.get("metric_type");
            String[] tags = Arrays.asList((String[])metric.get("tags")).toArray(new String[0]);
            if ("gauge".equals(metricType) || "histogram".equals(metricType)) {
                this.sendMetricPoint(metricType, metricName, currentValue, tags);
                continue;
            }
            if ("monotonic_count".equals(metricType)) {
                key = this.generateId(metric);
                if (!instanceCountersAggregator.containsKey(key)) {
                    instanceCountersAggregator.put(key, currentValue.longValue());
                    continue;
                }
                long oldValue = (Long)instanceCountersAggregator.get(key);
                long delta = currentValue.longValue() - oldValue;
                if (Double.isNaN(delta) || Double.isInfinite(delta)) continue;
                instanceCountersAggregator.put(key, currentValue.longValue());
                if (delta < 0L) {
                    log.info("Counter " + metricName + " has been reset - not submitting.");
                    continue;
                }
                this.sendMetricPoint(metricType, metricName, delta, tags);
                continue;
            }
            key = this.generateId(metric);
            if (!instanceRatesAggregator.containsKey(key)) {
                HashMap<String, Number> rateInfo = new HashMap<String, Number>();
                rateInfo.put("ts", System.currentTimeMillis());
                rateInfo.put(VALUE, currentValue);
                instanceRatesAggregator.put(key, rateInfo);
                continue;
            }
            long oldTs = (Long)((HashMap)instanceRatesAggregator.get(key)).get("ts");
            double oldValue = (Double)((HashMap)instanceRatesAggregator.get(key)).get(VALUE);
            long now = System.currentTimeMillis();
            double rate = 1000.0 * (currentValue - oldValue) / (double)(now - oldTs);
            boolean sane = !Double.isNaN(rate) && !Double.isInfinite(rate);
            boolean bl = submit = rate >= 0.0 || !canonicalRate;
            if (sane && submit) {
                this.sendMetricPoint(metricType, metricName, rate, tags);
            } else if (sane) {
                log.info("Canonical rate option set, and negative rate (counter reset)not submitting.");
            }
            ((HashMap)instanceRatesAggregator.get(key)).put("ts", now);
            ((HashMap)instanceRatesAggregator.get(key)).put(VALUE, currentValue);
        }
        this.ratesAggregator.put(instanceName, instanceRatesAggregator);
        this.countersAggregator.put(instanceName, instanceCountersAggregator);
    }

    public void sendServiceCheck(String checkName, String status, String message, String[] tags) {
        this.incrementServiceCheckCount(checkName);
        String dataName = Reporter.formatServiceCheckPrefix(checkName);
        this.doSendServiceCheck(dataName, status, message, tags);
    }

    public void incrementServiceCheckCount(String checkName) {
        int scCount = this.getServiceCheckCount(checkName);
        this.getServiceCheckCountMap().put(checkName, new Integer(scCount + 1));
    }

    public int getServiceCheckCount(String checkName) {
        Integer scCount = this.serviceCheckCount.get(checkName);
        return scCount == null ? 0 : scCount;
    }

    public void resetServiceCheckCount(String checkName) {
        this.serviceCheckCount.put(checkName, new Integer(0));
    }

    protected HashMap<String, Integer> getServiceCheckCountMap() {
        return this.serviceCheckCount;
    }

    public static String formatServiceCheckPrefix(String fullname) {
        Object[] chunks = fullname.split("\\.");
        chunks[0] = chunks[0].replaceAll("[A-Z0-9:_\\-]", "");
        return StringUtils.join((Object[])chunks, (String)".");
    }

    protected abstract void sendMetricPoint(String var1, String var2, double var3, String[] var5);

    protected abstract void doSendServiceCheck(String var1, String var2, String var3, String[] var4);

    public abstract void displayMetricReached();

    public abstract void displayNonMatchingAttributeName(JmxAttribute var1);

    public abstract void displayInstanceName(Instance var1);

    public abstract void displayMatchingAttributeName(JmxAttribute var1, int var2, int var3);
}

