/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

class Filter {
    Map<String, Object> filter;
    Pattern domainRegex;
    Pattern classNameRegex;
    List<Pattern> beanRegexes = null;
    List<String> excludeTags = null;
    Map<String, String> additionalTags = null;

    public Filter(Object filter) {
        HashMap<String, Object> castFilter = filter != null ? (HashMap<String, Object>)filter : new HashMap<String, Object>();
        this.filter = castFilter;
    }

    public String toString() {
        return this.filter.toString();
    }

    public Set<String> keySet() {
        return this.filter.keySet();
    }

    private static List<String> toStringList(Object toCast) {
        if (toCast instanceof List) {
            return (List)toCast;
        }
        return new ArrayList<String>(Arrays.asList((String)toCast));
    }

    public List<String> getBeanNames() {
        if (this.isEmptyBeanName()) {
            return Collections.emptyList();
        }
        Object beanNames = this.filter.get("bean") != null ? this.filter.get("bean") : this.filter.get("bean_name");
        return Filter.toStringList(beanNames);
    }

    private static List<Pattern> toPatternList(Object toCast) {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        List<String> stringList = Filter.toStringList(toCast);
        for (String string : stringList) {
            patternList.add(Pattern.compile(string));
        }
        return patternList;
    }

    public List<Pattern> getBeanRegexes() {
        if (this.beanRegexes == null) {
            if (this.filter.get("bean_regex") == null) {
                this.beanRegexes = Collections.emptyList();
            } else {
                Object beanRegexNames = this.filter.get("bean_regex");
                this.beanRegexes = Filter.toPatternList(beanRegexNames);
            }
        }
        return this.beanRegexes;
    }

    public List<String> getExcludeTags() {
        if (this.excludeTags == null) {
            if (this.filter.get("exclude_tags") == null) {
                this.excludeTags = Collections.emptyList();
            } else {
                Object exclude_tags = this.filter.get("exclude_tags");
                this.excludeTags = Filter.toStringList(exclude_tags);
            }
        }
        return this.excludeTags;
    }

    public Map<String, String> getAdditionalTags() {
        if (this.additionalTags == null) {
            this.additionalTags = this.filter.get("tags") == null ? new HashMap<String, String>() : (Map)this.filter.get("tags");
        }
        return this.additionalTags;
    }

    public String getDomain() {
        return (String)this.filter.get("domain");
    }

    public Pattern getDomainRegex() {
        if (this.filter.get("domain_regex") == null) {
            return null;
        }
        if (this.domainRegex == null) {
            this.domainRegex = Pattern.compile((String)this.filter.get("domain_regex"));
        }
        return this.domainRegex;
    }

    public String getClassName() {
        return (String)this.filter.get("class");
    }

    public Pattern getClassNameRegex() {
        if (this.filter.get("class_regex") == null) {
            return null;
        }
        if (this.classNameRegex == null) {
            this.classNameRegex = Pattern.compile((String)this.filter.get("class_regex"));
        }
        return this.classNameRegex;
    }

    public Object getAttribute() {
        return this.filter.get("attribute");
    }

    public List<String> getParameterValues(String parameterName) {
        Object beanValues = this.filter.get(parameterName);
        return Filter.toStringList(beanValues);
    }

    public boolean isEmptyBeanName() {
        return this.filter.get("bean") == null && this.filter.get("bean_name") == null;
    }

    public boolean isEmptyFilter() {
        return this.filter.isEmpty();
    }
}

