/*
 * Decompiled with CFR 0.152.
 */
package org.datadog.jmxfetch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.datadog.jmxfetch.Configuration;
import org.datadog.jmxfetch.Connection;
import org.datadog.jmxfetch.Filter;
import org.datadog.jmxfetch.Metric;
import org.datadog.jmxfetch.service.ServiceNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JmxAttribute {
    private static final Logger log = LoggerFactory.getLogger(JmxAttribute.class);
    protected static final String ALIAS = "alias";
    protected static final String METRIC_TYPE = "metric_type";
    private static final List<String> EXCLUDED_BEAN_PARAMS = Arrays.asList("domain", "domain_regex", "bean_name", "bean", "bean_regex", "class", "class_regex", "attribute", "exclude_tags", "tags");
    private static final String FIRST_CAP_PATTERN = "(.)([A-Z][a-z]+)";
    private static final String ALL_CAP_PATTERN = "([a-z0-9])([A-Z])";
    private static final String METRIC_REPLACEMENT = "([^a-zA-Z0-9_.]+)|(^[^a-zA-Z]+)";
    private static final String DOT_UNDERSCORE = "_*\\._*";
    protected static final String CASSANDRA_DOMAIN = "org.apache.cassandra.metrics";
    private MBeanAttributeInfo attribute;
    private Connection connection;
    private ObjectName beanName;
    private String domain;
    private String className;
    private String beanStringName;
    private ServiceNameProvider serviceNameProvider;
    private Map<String, String> beanParameters;
    private String attributeName;
    private Map<String, Map<Object, Object>> valueConversions = new HashMap<String, Map<Object, Object>>();
    protected String[] tags;
    private Configuration matchingConf;
    private List<String> defaultTagsList;
    private boolean cassandraAliasing;
    protected String checkName;

    JmxAttribute(MBeanAttributeInfo attribute, ObjectName beanName, String className, String instanceName, String checkName, Connection connection, ServiceNameProvider serviceNameProvider, Map<String, String> instanceTags, boolean cassandraAliasing, boolean emptyDefaultHostname) {
        this.attribute = attribute;
        this.beanName = beanName;
        this.className = className;
        this.matchingConf = null;
        this.connection = connection;
        this.attributeName = attribute.getName();
        this.beanStringName = beanName.toString();
        this.cassandraAliasing = cassandraAliasing;
        this.checkName = checkName;
        this.serviceNameProvider = serviceNameProvider;
        int splitPosition = this.beanStringName.indexOf(58);
        String domain = this.beanStringName.substring(0, splitPosition);
        String beanParameters = this.beanStringName.substring(splitPosition + 1);
        this.domain = domain;
        Map<String, String> beanParametersHash = JmxAttribute.getBeanParametersHash(beanParameters);
        List<String> beanParametersList = this.getBeanParametersList(instanceName, beanParametersHash, instanceTags);
        this.beanParameters = beanParametersHash;
        this.defaultTagsList = JmxAttribute.sanitizeParameters(beanParametersList);
        if (emptyDefaultHostname) {
            this.defaultTagsList.add("host:");
        }
    }

    private void applyTagsBlackList() {
        Filter include = this.matchingConf.getInclude();
        if (include != null) {
            for (String excludedTagName : include.getExcludeTags()) {
                Iterator<String> it = this.defaultTagsList.iterator();
                while (it.hasNext()) {
                    String tag = it.next();
                    if (!tag.startsWith(excludedTagName + ":")) continue;
                    it.remove();
                }
            }
        }
    }

    private void addAdditionalTags() {
        Filter include = this.matchingConf.getInclude();
        if (include != null) {
            for (Map.Entry<String, String> tag : include.getAdditionalTags().entrySet()) {
                String alias = this.replaceByAlias(tag.getValue());
                if (alias != null && alias.trim().length() > 0) {
                    this.defaultTagsList.add(tag.getKey() + ":" + alias);
                    continue;
                }
                log.warn("Unable to apply tag " + tag.getKey() + " - with unknown alias");
            }
        }
    }

    private void addServiceTags() {
        Iterable<String> serviceNames = this.serviceNameProvider.getServiceNames();
        if (serviceNames != null) {
            for (String serviceName : serviceNames) {
                this.defaultTagsList.add("service:" + serviceName);
            }
        }
    }

    public static Map<String, String> getBeanParametersHash(String beanParametersString) {
        String[] beanParameters = beanParametersString.split(",");
        HashMap<String, String> beanParamsMap = new HashMap<String, String>(beanParameters.length);
        for (String param : beanParameters) {
            String[] paramSplit = param.split("=");
            if (paramSplit.length > 1) {
                beanParamsMap.put(new String(paramSplit[0]), new String(paramSplit[1]));
                continue;
            }
            beanParamsMap.put(new String(paramSplit[0]), "");
        }
        return beanParamsMap;
    }

    private List<String> getBeanParametersList(String instanceName, Map<String, String> beanParameters, Map<String, String> instanceTags) {
        ArrayList<String> beanTags = new ArrayList<String>();
        beanTags.add("instance:" + instanceName);
        beanTags.add("jmx_domain:" + this.domain);
        if (this.renameCassandraMetrics().booleanValue()) {
            beanTags.addAll(JmxAttribute.getCassandraBeanTags(beanParameters));
        } else {
            for (Map.Entry<String, String> param : beanParameters.entrySet()) {
                beanTags.add(param.getKey() + ":" + param.getValue());
            }
        }
        if (instanceTags != null) {
            for (Map.Entry<String, String> tag : instanceTags.entrySet()) {
                if (tag.getValue() != null) {
                    beanTags.add(tag.getKey() + ":" + tag.getValue());
                    continue;
                }
                beanTags.add(tag.getKey());
            }
        }
        return beanTags;
    }

    private static List<String> sanitizeParameters(List<String> beanParametersList) {
        ArrayList<String> defaultTagsList = new ArrayList<String>(beanParametersList.size());
        for (String rawBeanParameter : beanParametersList) {
            String beanParameter = rawBeanParameter.replace("|", "");
            if (beanParameter.startsWith("host:")) {
                defaultTagsList.add("bean_host:" + beanParameter.substring("host:".length()));
                continue;
            }
            if (beanParameter.endsWith(":")) {
                defaultTagsList.add(beanParameter.substring(0, beanParameter.length() - 1));
                continue;
            }
            defaultTagsList.add(beanParameter);
        }
        return defaultTagsList;
    }

    protected Boolean renameCassandraMetrics() {
        return this.cassandraAliasing && this.domain.equals(CASSANDRA_DOMAIN);
    }

    private static Collection<String> getCassandraBeanTags(Map<String, String> beanParameters) {
        ArrayList<String> tags = new ArrayList<String>();
        for (Map.Entry<String, String> param : beanParameters.entrySet()) {
            if (param.getKey().equals("name")) continue;
            if (param.getKey().equals("scope")) {
                String type = beanParameters.get("type");
                tags.add(type + ":" + param.getValue());
                continue;
            }
            tags.add(param.getKey() + ":" + param.getValue());
        }
        return tags;
    }

    static String convertMetricName(String metricName) {
        metricName = metricName.replaceAll(FIRST_CAP_PATTERN, "$1_$2");
        metricName = metricName.replaceAll(ALL_CAP_PATTERN, "$1_$2").toLowerCase();
        metricName = metricName.replaceAll(METRIC_REPLACEMENT, "_");
        metricName = metricName.replaceAll(DOT_UNDERSCORE, ".").trim();
        return metricName;
    }

    public String toString() {
        return "Bean name: " + this.beanStringName + " - Attribute name: " + this.attributeName + "  - Attribute type: " + this.attribute.getType();
    }

    public abstract List<Metric> getMetrics() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException;

    public abstract boolean match(Configuration var1);

    public int getMetricsCount() {
        try {
            return this.getMetrics().size();
        }
        catch (Exception e) {
            log.warn("Unable to get metrics from " + this.beanStringName + " - " + this.attributeName + ": " + e.toString());
            return 0;
        }
    }

    Object getJmxValue() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.connection.getAttribute(this.beanName, this.attribute.getName());
    }

    boolean matchDomain(Configuration conf) {
        return this.includeMatchName(this.domain, conf.getInclude().getDomain(), conf.getInclude().getDomainRegex());
    }

    boolean excludeMatchDomain(Configuration conf) {
        return this.excludeMatchName(this.domain, conf.getExclude().getDomain(), conf.getExclude().getDomainRegex());
    }

    boolean matchClassName(Configuration conf) {
        return this.includeMatchName(this.className, conf.getInclude().getClassName(), conf.getInclude().getClassNameRegex());
    }

    boolean excludeMatchClassName(Configuration conf) {
        return this.excludeMatchName(this.className, conf.getExclude().getClassName(), conf.getExclude().getClassNameRegex());
    }

    private boolean includeMatchName(String name, String includeName, Pattern includeNameRegex) {
        return !(includeName != null && !includeName.equals(name) || includeNameRegex != null && !includeNameRegex.matcher(name).matches());
    }

    private boolean excludeMatchName(String name, String excludeName, Pattern excludeNameRegex) {
        return excludeName != null && excludeName.equals(name) || excludeNameRegex != null && excludeNameRegex.matcher(name).matches();
    }

    Object convertMetricValue(Object metricValue, String field) {
        Object converted = metricValue;
        Map<Object, Object> valueConversions = this.getValueConversions(field);
        if (valueConversions == null || valueConversions.isEmpty()) {
            return converted;
        }
        converted = valueConversions.get(metricValue);
        if (converted != null) {
            return converted;
        }
        return valueConversions.get("default");
    }

    double castToDouble(Object metricValue, String field) {
        Object value = this.convertMetricValue(metricValue, field);
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof Integer) {
            return new Double(((Integer)value).intValue());
        }
        if (value instanceof AtomicInteger) {
            return new Double(((AtomicInteger)value).get());
        }
        if (value instanceof AtomicLong) {
            Long longValue = ((AtomicLong)value).get();
            return longValue.doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof Long) {
            Long longValue = new Long((Long)value);
            return longValue.doubleValue();
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return new Double((Double)value);
        }
        catch (Exception e) {
            throw new NumberFormatException();
        }
    }

    private boolean matchBeanRegex(Filter filter, boolean matchIfNoRegex) {
        List<Pattern> beanRegexes = filter.getBeanRegexes();
        if (beanRegexes.isEmpty()) {
            return matchIfNoRegex;
        }
        for (Pattern beanRegex : beanRegexes) {
            Matcher matcher = beanRegex.matcher(this.beanStringName);
            if (!matcher.matches()) continue;
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                this.beanParameters.put(Integer.toString(i), matcher.group(i));
            }
            return true;
        }
        return false;
    }

    private boolean matchBeanName(Configuration configuration) {
        Filter include = configuration.getInclude();
        if (!include.isEmptyBeanName() && !include.getBeanNames().contains(this.beanStringName)) {
            return false;
        }
        for (String beanAttr : include.keySet()) {
            if (EXCLUDED_BEAN_PARAMS.contains(beanAttr)) continue;
            List<String> beanValues = include.getParameterValues(beanAttr);
            if (this.beanParameters.get(beanAttr) != null && beanValues.contains(this.beanParameters.get(beanAttr))) continue;
            return false;
        }
        return true;
    }

    private boolean excludeMatchBeanName(Configuration conf) {
        Filter exclude = conf.getExclude();
        List<String> beanNames = exclude.getBeanNames();
        if (beanNames.contains(this.beanStringName)) {
            return true;
        }
        for (String beanAttr : exclude.keySet()) {
            if (EXCLUDED_BEAN_PARAMS.contains(beanAttr) || this.beanParameters.get(beanAttr) == null) continue;
            List<String> beanValues = exclude.getParameterValues(beanAttr);
            for (String beanVal : beanValues) {
                if (!this.beanParameters.get(beanAttr).equals(beanVal)) continue;
                return true;
            }
        }
        return false;
    }

    boolean matchBean(Configuration configuration) {
        return this.matchBeanName(configuration) && this.matchBeanRegex(configuration.getInclude(), true);
    }

    boolean excludeMatchBean(Configuration configuration) {
        return this.excludeMatchBeanName(configuration) || this.matchBeanRegex(configuration.getExclude(), false);
    }

    Map<Object, Object> getValueConversions(String field) {
        String fullAttributeName;
        String string = fullAttributeName = field != null ? this.getAttribute().getName() + "." + field : this.getAttribute().getName();
        if (this.valueConversions.get(fullAttributeName) == null) {
            Map attribute;
            Object includedAttribute = this.matchingConf.getInclude().getAttribute();
            if (includedAttribute instanceof Map && (attribute = (Map)((Map)includedAttribute).get(fullAttributeName)) != null) {
                this.valueConversions.put(fullAttributeName, (Map<Object, Object>)attribute.get("values"));
            }
            if (this.valueConversions.get(fullAttributeName) == null) {
                this.valueConversions.put(fullAttributeName, new HashMap());
            }
        }
        return this.valueConversions.get(fullAttributeName);
    }

    public Configuration getMatchingConf() {
        return this.matchingConf;
    }

    public void setMatchingConf(Configuration matchingConf) {
        this.matchingConf = matchingConf;
        this.addAdditionalTags();
        this.applyTagsBlackList();
        this.addServiceTags();
    }

    MBeanAttributeInfo getAttribute() {
        return this.attribute;
    }

    public ObjectName getBeanName() {
        return this.beanName;
    }

    protected String getAlias(String field) {
        String fullAttributeName;
        String alias = null;
        Filter include = this.getMatchingConf().getInclude();
        Map<String, Object> conf = this.getMatchingConf().getConf();
        String string = fullAttributeName = field != null ? this.getAttribute().getName() + "." + field : this.getAttribute().getName();
        if (include.getAttribute() instanceof Map) {
            Map attribute = (Map)include.getAttribute();
            alias = this.getUserAlias(attribute, fullAttributeName);
        }
        if (alias == null) {
            if (conf.get("metric_prefix") != null) {
                alias = conf.get("metric_prefix") + "." + this.getDomain() + "." + fullAttributeName;
            } else if (this.getDomain().startsWith("org.apache.cassandra")) {
                alias = this.getCassandraAlias();
            }
        }
        if (alias == null) {
            alias = "jmx." + this.getDomain() + "." + fullAttributeName;
        }
        alias = JmxAttribute.convertMetricName(alias);
        return alias;
    }

    private String getCassandraAlias() {
        if (this.renameCassandraMetrics().booleanValue()) {
            Map<String, String> beanParameters = this.getBeanParameters();
            String metricName = beanParameters.get("name");
            String attributeName = this.getAttributeName();
            if (attributeName.equals("Value")) {
                return "cassandra." + metricName;
            }
            return "cassandra." + metricName + "." + attributeName;
        }
        return this.getDomain().replace("org.apache.", "") + "." + this.getAttributeName();
    }

    private String getUserAlias(Map<String, Map<String, String>> attribute, String fullAttributeName) {
        String alias = attribute.get(fullAttributeName).get(ALIAS);
        if (alias == null) {
            return null;
        }
        alias = this.replaceByAlias(alias);
        alias = alias.replace("$attribute", fullAttributeName);
        if ((alias = alias.replace("$domain", this.domain)).contains("$value")) {
            try {
                alias = alias.replace("$value", this.getJmxValue().toString());
            }
            catch (JMException e) {
                log.warn("Unable to replace $value for attribute " + fullAttributeName, (Throwable)e);
            }
            catch (IOException e) {
                log.warn("Unable to replace $value for attribute " + fullAttributeName, (Throwable)e);
            }
        }
        return alias;
    }

    private String replaceByAlias(String alias) {
        for (Map.Entry<String, String> param : this.beanParameters.entrySet()) {
            alias = alias.replace("$" + param.getKey(), param.getValue());
        }
        return alias;
    }

    protected String[] getTags() {
        List yamlTags;
        Map attributeParams;
        Object includeAttribute;
        if (this.tags != null) {
            return this.tags;
        }
        Filter include = this.matchingConf.getInclude();
        if (include != null && (includeAttribute = include.getAttribute()) instanceof Map && (attributeParams = (Map)((Map)includeAttribute).get(this.attributeName)) != null && (yamlTags = (List)attributeParams.get("tags")) != null) {
            this.defaultTagsList.addAll(yamlTags);
        }
        this.tags = new String[this.defaultTagsList.size()];
        this.tags = this.defaultTagsList.toArray(this.tags);
        return this.tags;
    }

    String getBeanStringName() {
        return this.beanStringName;
    }

    String getAttributeName() {
        return this.attributeName;
    }

    public static List<String> getExcludedBeanParams() {
        return EXCLUDED_BEAN_PARAMS;
    }

    protected String getDomain() {
        return this.domain;
    }

    protected Map<String, String> getBeanParameters() {
        return this.beanParameters;
    }

    protected String getMetricType(String subAttribute) {
        Map attribute;
        Map attrInfo;
        String localMetricType = null;
        String name = subAttribute != null ? this.getAttribute().getName() + "." + subAttribute : this.attributeName;
        Filter include = this.getMatchingConf().getInclude();
        if (include.getAttribute() instanceof Map && (localMetricType = (String)(attrInfo = (Map)(attribute = (Map)include.getAttribute()).get(name)).get(METRIC_TYPE)) == null) {
            localMetricType = (String)attrInfo.get("type");
        }
        if (localMetricType == null) {
            localMetricType = "gauge";
        }
        return localMetricType;
    }
}

