/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch;

import com.datadoghq.sketch.QuantileSketch;
import com.datadoghq.sketch.ddsketch.mapping.BitwiseLinearlyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import com.datadoghq.sketch.ddsketch.mapping.LogarithmicMapping;
import com.datadoghq.sketch.ddsketch.mapping.QuadraticallyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.CollapsingHighestDenseStore;
import com.datadoghq.sketch.ddsketch.store.CollapsingLowestDenseStore;
import com.datadoghq.sketch.ddsketch.store.Store;
import com.datadoghq.sketch.ddsketch.store.UnboundedSizeDenseStore;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class DDSketch
implements QuantileSketch<DDSketch> {
    private final IndexMapping indexMapping;
    private final double minIndexedValue;
    private final double maxIndexedValue;
    private final Store store;
    private long zeroCount;

    public DDSketch(IndexMapping indexMapping, Supplier<Store> storeSupplier) {
        this(indexMapping, storeSupplier, 0.0);
    }

    public DDSketch(IndexMapping indexMapping, Supplier<Store> storeSupplier, double minIndexedValue) {
        this.indexMapping = indexMapping;
        this.minIndexedValue = Math.max(minIndexedValue, indexMapping.minIndexableValue());
        this.maxIndexedValue = indexMapping.maxIndexableValue();
        this.store = storeSupplier.get();
        this.zeroCount = 0L;
    }

    private DDSketch(DDSketch sketch) {
        this.indexMapping = sketch.indexMapping;
        this.minIndexedValue = sketch.minIndexedValue;
        this.maxIndexedValue = sketch.maxIndexedValue;
        this.store = sketch.store.copy();
        this.zeroCount = sketch.zeroCount;
    }

    public IndexMapping getIndexMapping() {
        return this.indexMapping;
    }

    public Store getStore() {
        return this.store;
    }

    @Override
    public void accept(double value) {
        this.checkValueTrackable(value);
        if (value < this.minIndexedValue) {
            ++this.zeroCount;
        } else {
            this.store.add(this.indexMapping.index(value));
        }
    }

    @Override
    public void accept(double value, long count) {
        this.checkValueTrackable(value);
        if (value < this.minIndexedValue) {
            if (count < 0L) {
                throw new IllegalArgumentException("The count cannot be negative.");
            }
            this.zeroCount += count;
        } else {
            this.store.add(this.indexMapping.index(value), count);
        }
    }

    private void checkValueTrackable(double value) {
        if (value < 0.0 || value > this.maxIndexedValue) {
            throw new IllegalArgumentException("The input value is outside the range that is tracked by the sketch.");
        }
    }

    @Override
    public void mergeWith(DDSketch other) {
        if (!this.indexMapping.equals(other.indexMapping)) {
            throw new IllegalArgumentException("The sketches are not mergeable because they do not use the same index mappings.");
        }
        this.store.mergeWith(other.store);
        this.zeroCount += other.zeroCount;
    }

    @Override
    public DDSketch copy() {
        return new DDSketch(this);
    }

    @Override
    public boolean isEmpty() {
        return this.zeroCount == 0L && this.store.isEmpty();
    }

    @Override
    public long getCount() {
        return this.zeroCount + this.store.getTotalCount();
    }

    @Override
    public double getMinValue() {
        if (this.zeroCount > 0L) {
            return 0.0;
        }
        return this.indexMapping.value(this.store.getMinIndex());
    }

    @Override
    public double getMaxValue() {
        if (this.zeroCount > 0L && this.store.isEmpty()) {
            return 0.0;
        }
        return this.indexMapping.value(this.store.getMaxIndex());
    }

    @Override
    public double getValueAtQuantile(double quantile) {
        return this.getValueAtQuantile(quantile, this.getCount());
    }

    @Override
    public double[] getValuesAtQuantiles(double[] quantiles) {
        long count = this.getCount();
        return Arrays.stream(quantiles).map(quantile -> this.getValueAtQuantile(quantile, count)).toArray();
    }

    private double getValueAtQuantile(double quantile, long count) {
        Bin bin;
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException("The quantile must be between 0 and 1.");
        }
        if (count == 0L) {
            throw new NoSuchElementException();
        }
        long rank = (long)(quantile * (double)(count - 1L));
        if (rank < this.zeroCount) {
            return 0.0;
        }
        if (quantile <= 0.5) {
            Iterator<Bin> binIterator = this.store.getAscendingIterator();
            long n = this.zeroCount;
            while ((n += (bin = binIterator.next()).getCount()) <= rank && binIterator.hasNext()) {
            }
        } else {
            Iterator<Bin> binIterator = this.store.getDescendingIterator();
            long n = count;
            while ((n -= (bin = binIterator.next()).getCount()) > rank && binIterator.hasNext()) {
            }
        }
        return this.indexMapping.value(bin.getIndex());
    }

    public static DDSketch standard(double relativeAccuracy) {
        return new DDSketch(new QuadraticallyInterpolatedMapping(relativeAccuracy), UnboundedSizeDenseStore::new);
    }

    public static DDSketch standardCollapsingLowest(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new QuadraticallyInterpolatedMapping(relativeAccuracy), () -> new CollapsingLowestDenseStore(maxNumBins));
    }

    public static DDSketch standardCollapsingHighest(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new QuadraticallyInterpolatedMapping(relativeAccuracy), () -> new CollapsingHighestDenseStore(maxNumBins));
    }

    public static DDSketch fast(double relativeAccuracy) {
        return new DDSketch(new BitwiseLinearlyInterpolatedMapping(relativeAccuracy), UnboundedSizeDenseStore::new);
    }

    public static DDSketch fastCollapsingLowest(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new BitwiseLinearlyInterpolatedMapping(relativeAccuracy), () -> new CollapsingLowestDenseStore(maxNumBins));
    }

    public static DDSketch fastCollapsingHighest(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new BitwiseLinearlyInterpolatedMapping(relativeAccuracy), () -> new CollapsingHighestDenseStore(maxNumBins));
    }

    public static DDSketch memoryOptimal(double relativeAccuracy) {
        return new DDSketch(new LogarithmicMapping(relativeAccuracy), UnboundedSizeDenseStore::new);
    }

    public static DDSketch memoryOptimalCollapsingLowest(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new LogarithmicMapping(relativeAccuracy), () -> new CollapsingLowestDenseStore(maxNumBins));
    }

    public static DDSketch memoryOptimalCollapsingHighest(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new LogarithmicMapping(relativeAccuracy), () -> new CollapsingHighestDenseStore(maxNumBins));
    }
}

