/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.mapping.DoubleBitOperationHelper;
import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import java.util.Objects;

public class BitwiseLinearlyInterpolatedMapping
implements IndexMapping {
    private final int numSignificantBinaryDigits;
    private final int partialSignificandShift;
    private final int multiplier;
    private final double relativeAccuracy;

    public BitwiseLinearlyInterpolatedMapping(double relativeAccuracy) {
        this(BitwiseLinearlyInterpolatedMapping.getMinNumSignificantBinaryDigits(relativeAccuracy));
    }

    private BitwiseLinearlyInterpolatedMapping(int numSignificantBinaryDigits) {
        if (numSignificantBinaryDigits < 0) {
            throw new IllegalArgumentException("The number of significant binary digits cannot be negative.");
        }
        this.numSignificantBinaryDigits = numSignificantBinaryDigits;
        this.partialSignificandShift = 53 - numSignificantBinaryDigits - 1;
        this.multiplier = 1 << numSignificantBinaryDigits;
        this.relativeAccuracy = 1.0 - 1.0 / (1.0 + Math.pow(2.0, -(numSignificantBinaryDigits + 1)));
    }

    private static int getMinNumSignificantBinaryDigits(double relativeAccuracy) {
        if (relativeAccuracy <= 0.0 || relativeAccuracy >= 1.0) {
            throw new IllegalArgumentException("The relative accuracy must be between 0 and 1.");
        }
        return Math.max((int)Math.ceil(Math.log(1.0 / relativeAccuracy - 1.0) / Math.log(2.0) - 1.0), 0);
    }

    @Override
    public int index(double value) {
        long longBits = Double.doubleToRawLongBits(value);
        return (int)(DoubleBitOperationHelper.getExponent(longBits) << this.numSignificantBinaryDigits | this.getPartialSignificand(longBits));
    }

    private long getPartialSignificand(long longBits) {
        return (longBits & 0xFFFFFFFFFFFFFL) >> this.partialSignificandShift;
    }

    @Override
    public double value(int index) {
        int exponent = Math.floorDiv(index, this.multiplier);
        return DoubleBitOperationHelper.buildDouble(exponent, (double)(1 - exponent) + (double)index / (double)this.multiplier) * (1.0 + this.relativeAccuracy);
    }

    @Override
    public double relativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double minIndexableValue() {
        return Math.max(Math.pow(2.0, Integer.MIN_VALUE / this.multiplier + 1), Double.MIN_NORMAL * (1.0 + this.relativeAccuracy) / (1.0 - this.relativeAccuracy));
    }

    @Override
    public double maxIndexableValue() {
        return Math.min(Math.pow(2.0, Integer.MAX_VALUE / this.multiplier), Double.MAX_VALUE / (1.0 + this.relativeAccuracy));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.numSignificantBinaryDigits == ((BitwiseLinearlyInterpolatedMapping)o).numSignificantBinaryDigits;
    }

    public int hashCode() {
        return Objects.hash(this.numSignificantBinaryDigits);
    }
}

