/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import java.util.Objects;

public class LogarithmicMapping
implements IndexMapping {
    private final double relativeAccuracy;
    private final double logGamma;

    public LogarithmicMapping(double relativeAccuracy) {
        if (relativeAccuracy <= 0.0 || relativeAccuracy >= 1.0) {
            throw new IllegalArgumentException("The relative accuracy must be between 0 and 1.");
        }
        this.relativeAccuracy = relativeAccuracy;
        this.logGamma = Math.log((1.0 + relativeAccuracy) / (1.0 - relativeAccuracy));
    }

    @Override
    public int index(double value) {
        double index = Math.log(value) / this.logGamma;
        return index >= 0.0 ? (int)index : (int)index - 1;
    }

    @Override
    public double value(int index) {
        return Math.exp((double)index * this.logGamma) * (1.0 + this.relativeAccuracy);
    }

    @Override
    public double relativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double minIndexableValue() {
        return Math.max(Math.exp(-2.147483647E9 * this.logGamma), Double.MIN_NORMAL * Math.exp(this.logGamma));
    }

    @Override
    public double maxIndexableValue() {
        return Math.min(Math.exp(2.147483647E9 * this.logGamma), Double.MAX_VALUE / (1.0 + this.relativeAccuracy));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Double.compare(this.relativeAccuracy, ((LogarithmicMapping)o).relativeAccuracy) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.relativeAccuracy);
    }
}

