/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.mapping.DoubleBitOperationHelper;
import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import java.util.Objects;

public class LinearlyInterpolatedMapping
implements IndexMapping {
    private final double relativeAccuracy;
    private final double multiplier;

    public LinearlyInterpolatedMapping(double relativeAccuracy) {
        if (relativeAccuracy <= 0.0 || relativeAccuracy >= 1.0) {
            throw new IllegalArgumentException("The relative accuracy must be between 0 and 1.");
        }
        this.relativeAccuracy = relativeAccuracy;
        this.multiplier = 1.0 / Math.log((1.0 + relativeAccuracy) / (1.0 - relativeAccuracy));
    }

    @Override
    public int index(double value) {
        long longBits = Double.doubleToRawLongBits(value);
        double index = this.multiplier * ((double)DoubleBitOperationHelper.getExponent(longBits) + DoubleBitOperationHelper.getSignificandPlusOne(longBits));
        return index >= 0.0 ? (int)index : (int)index - 1;
    }

    @Override
    public double value(int index) {
        double normalizedIndex = (double)index / this.multiplier;
        long exponent = (long)Math.floor(normalizedIndex - 1.0);
        double significandPlusOne = normalizedIndex - (double)exponent;
        return DoubleBitOperationHelper.buildDouble(exponent, significandPlusOne) * (1.0 + this.relativeAccuracy);
    }

    @Override
    public double relativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double minIndexableValue() {
        return Math.max(Math.pow(2.0, -2.147483647E9 / this.multiplier), Double.MIN_NORMAL * (1.0 + this.relativeAccuracy) / (1.0 - this.relativeAccuracy));
    }

    @Override
    public double maxIndexableValue() {
        return Math.min(Math.pow(2.0, 2.147483647E9 / this.multiplier - 1.0), Double.MAX_VALUE / (1.0 + this.relativeAccuracy));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Double.compare(this.relativeAccuracy, ((LinearlyInterpolatedMapping)o).relativeAccuracy) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.relativeAccuracy);
    }
}

