/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.store;

import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.Store;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;

public class SparseStore
implements Store {
    private final NavigableMap<Integer, Long> bins;

    public SparseStore() {
        this.bins = new TreeMap<Integer, Long>();
    }

    private SparseStore(SparseStore store) {
        this.bins = new TreeMap<Integer, Long>((SortedMap<Integer, Long>)store.bins);
    }

    @Override
    public void add(int index) {
        this.bins.merge(index, 1L, Long::sum);
    }

    @Override
    public void add(int index, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        if (count == 0L) {
            return;
        }
        this.bins.merge(index, count, Long::sum);
    }

    @Override
    public void add(Bin bin) {
        if (bin.getCount() == 0L) {
            return;
        }
        this.bins.merge(bin.getIndex(), bin.getCount(), Long::sum);
    }

    @Override
    public Store copy() {
        return new SparseStore(this);
    }

    @Override
    public int getMinIndex() {
        return (Integer)this.bins.firstKey();
    }

    @Override
    public int getMaxIndex() {
        return (Integer)this.bins.lastKey();
    }

    @Override
    public Iterator<Bin> getAscendingIterator() {
        return SparseStore.getBinIterator(this.bins);
    }

    @Override
    public Iterator<Bin> getDescendingIterator() {
        return SparseStore.getBinIterator(this.bins.descendingMap());
    }

    private static Iterator<Bin> getBinIterator(Map<Integer, Long> bins) {
        final Iterator<Map.Entry<Integer, Long>> iterator = bins.entrySet().iterator();
        return new Iterator<Bin>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Bin next() {
                Map.Entry nextEntry = (Map.Entry)iterator.next();
                return new Bin((Integer)nextEntry.getKey(), (Long)nextEntry.getValue());
            }
        };
    }
}

