/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch;

import com.datadoghq.sketch.QuantileSketch;
import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.Store;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class SignedDDSketch
implements QuantileSketch<SignedDDSketch> {
    private final IndexMapping indexMapping;
    private final double minIndexedValue;
    private final double maxIndexedValue;
    private final Store negativeValueStore;
    private final Store positiveValueStore;
    private long zeroCount;

    public SignedDDSketch(IndexMapping indexMapping, Supplier<Store> storeSupplier) {
        this(indexMapping, storeSupplier, storeSupplier, 0.0);
    }

    public SignedDDSketch(IndexMapping indexMapping, Supplier<Store> negativeValueStoreSupplier, Supplier<Store> positiveValueStoreSupplier) {
        this(indexMapping, negativeValueStoreSupplier, positiveValueStoreSupplier, 0.0);
    }

    public SignedDDSketch(IndexMapping indexMapping, Supplier<Store> negativeValueStoreSupplier, Supplier<Store> positiveValueStoreSupplier, double minIndexedValue) {
        this.indexMapping = indexMapping;
        this.minIndexedValue = Math.max(minIndexedValue, indexMapping.minIndexableValue());
        this.maxIndexedValue = indexMapping.maxIndexableValue();
        this.negativeValueStore = negativeValueStoreSupplier.get();
        this.positiveValueStore = positiveValueStoreSupplier.get();
        this.zeroCount = 0L;
    }

    private SignedDDSketch(SignedDDSketch sketch) {
        this.indexMapping = sketch.indexMapping;
        this.minIndexedValue = sketch.minIndexedValue;
        this.maxIndexedValue = sketch.maxIndexedValue;
        this.negativeValueStore = sketch.negativeValueStore.copy();
        this.positiveValueStore = sketch.positiveValueStore.copy();
        this.zeroCount = sketch.zeroCount;
    }

    public IndexMapping getIndexMapping() {
        return this.indexMapping;
    }

    public Store getNegativeValueStore() {
        return this.negativeValueStore;
    }

    public Store getPositiveValueStore() {
        return this.positiveValueStore;
    }

    @Override
    public void accept(double value) {
        this.checkValueTrackable(value);
        if (value > this.minIndexedValue) {
            this.positiveValueStore.add(this.indexMapping.index(value));
        } else if (value < -this.minIndexedValue) {
            this.negativeValueStore.add(this.indexMapping.index(-value));
        } else {
            ++this.zeroCount;
        }
    }

    @Override
    public void accept(double value, long count) {
        this.checkValueTrackable(value);
        if (count < 0L) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        if (value > this.minIndexedValue) {
            this.positiveValueStore.add(this.indexMapping.index(value), count);
        } else if (value < -this.minIndexedValue) {
            this.negativeValueStore.add(this.indexMapping.index(-value), count);
        } else {
            this.zeroCount += count;
        }
    }

    private void checkValueTrackable(double value) {
        if (value < -this.maxIndexedValue || value > this.maxIndexedValue) {
            throw new IllegalArgumentException("The input value is outside the range that is tracked by the sketch.");
        }
    }

    @Override
    public void mergeWith(SignedDDSketch other) {
        if (!this.indexMapping.equals(other.indexMapping)) {
            throw new IllegalArgumentException("The sketches are not mergeable because they do not use the same index mappings.");
        }
        this.negativeValueStore.mergeWith(other.negativeValueStore);
        this.positiveValueStore.mergeWith(other.positiveValueStore);
        this.zeroCount += other.zeroCount;
    }

    @Override
    public SignedDDSketch copy() {
        return new SignedDDSketch(this);
    }

    @Override
    public boolean isEmpty() {
        return this.zeroCount == 0L && this.negativeValueStore.isEmpty() && this.positiveValueStore.isEmpty();
    }

    @Override
    public long getCount() {
        return this.zeroCount + this.negativeValueStore.getTotalCount() + this.positiveValueStore.getTotalCount();
    }

    @Override
    public double getMinValue() {
        if (!this.negativeValueStore.isEmpty()) {
            return -this.indexMapping.value(this.negativeValueStore.getMaxIndex());
        }
        if (this.zeroCount > 0L) {
            return 0.0;
        }
        return this.indexMapping.value(this.positiveValueStore.getMinIndex());
    }

    @Override
    public double getMaxValue() {
        if (!this.positiveValueStore.isEmpty()) {
            return this.indexMapping.value(this.positiveValueStore.getMaxIndex());
        }
        if (this.zeroCount > 0L) {
            return 0.0;
        }
        return -this.indexMapping.value(this.negativeValueStore.getMinIndex());
    }

    @Override
    public double getValueAtQuantile(double quantile) {
        return this.getValueAtQuantile(quantile, this.getCount());
    }

    @Override
    public double[] getValuesAtQuantiles(double[] quantiles) {
        long count = this.getCount();
        return Arrays.stream(quantiles).map(quantile -> this.getValueAtQuantile(quantile, count)).toArray();
    }

    private double getValueAtQuantile(double quantile, long count) {
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException("The quantile must be between 0 and 1.");
        }
        if (count == 0L) {
            throw new NoSuchElementException();
        }
        long rank = (long)(quantile * (double)(count - 1L));
        long n = 0L;
        Iterator<Bin> negativeBinIterator = this.negativeValueStore.getDescendingIterator();
        while (negativeBinIterator.hasNext()) {
            Bin bin = negativeBinIterator.next();
            if ((n += bin.getCount()) <= rank) continue;
            return -this.indexMapping.value(bin.getIndex());
        }
        if ((n += this.zeroCount) > rank) {
            return 0.0;
        }
        Iterator<Bin> positiveBinIterator = this.positiveValueStore.getAscendingIterator();
        while (positiveBinIterator.hasNext()) {
            Bin bin = positiveBinIterator.next();
            if ((n += bin.getCount()) <= rank) continue;
            return this.indexMapping.value(bin.getIndex());
        }
        throw new NoSuchElementException();
    }
}

