/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.store;

import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.Store;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class DenseStore
implements Store {
    private static final int DEFAULT_ARRAY_LENGTH_GROWTH_INCREMENT = 64;
    private static final double DEFAULT_ARRAY_LENGTH_OVERHEAD_RATIO = 0.1;
    private final int arrayLengthGrowthIncrement;
    private final int arrayLengthOverhead;
    long[] counts;
    int offset;
    int minIndex;
    int maxIndex;

    DenseStore() {
        this(64);
    }

    DenseStore(int arrayLengthGrowthIncrement) {
        this(arrayLengthGrowthIncrement, (int)((double)arrayLengthGrowthIncrement * 0.1));
    }

    DenseStore(int arrayLengthGrowthIncrement, int arrayLengthOverhead) {
        if (arrayLengthGrowthIncrement <= 0 || arrayLengthOverhead < 0) {
            throw new IllegalArgumentException("The array growth parameters are not valid.");
        }
        this.arrayLengthGrowthIncrement = arrayLengthGrowthIncrement;
        this.arrayLengthOverhead = arrayLengthOverhead;
        this.counts = null;
        this.offset = 0;
        this.minIndex = Integer.MAX_VALUE;
        this.maxIndex = Integer.MIN_VALUE;
    }

    DenseStore(DenseStore store) {
        this.arrayLengthGrowthIncrement = store.arrayLengthGrowthIncrement;
        this.arrayLengthOverhead = store.arrayLengthOverhead;
        this.counts = store.counts == null ? null : Arrays.copyOf(store.counts, store.counts.length);
        this.offset = store.offset;
        this.minIndex = store.minIndex;
        this.maxIndex = store.maxIndex;
    }

    @Override
    public void add(int index) {
        int arrayIndex;
        int n = arrayIndex = this.normalize(index);
        this.counts[n] = this.counts[n] + 1L;
    }

    @Override
    public void add(int index, long count) {
        int arrayIndex;
        if (count < 0L) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        if (count == 0L) {
            return;
        }
        int n = arrayIndex = this.normalize(index);
        this.counts[n] = this.counts[n] + count;
    }

    @Override
    public void add(Bin bin) {
        int arrayIndex;
        if (bin.getCount() == 0L) {
            return;
        }
        int n = arrayIndex = this.normalize(bin.getIndex());
        this.counts[n] = this.counts[n] + bin.getCount();
    }

    abstract int normalize(int var1);

    abstract void adjust(int var1, int var2);

    void extendRange(int index) {
        this.extendRange(index, index);
    }

    void extendRange(int newMinIndex, int newMaxIndex) {
        newMinIndex = Math.min(newMinIndex, this.minIndex);
        newMaxIndex = Math.max(newMaxIndex, this.maxIndex);
        if (this.isEmpty()) {
            int initialLength = this.getNewLength(newMaxIndex - newMinIndex + 1);
            this.counts = new long[initialLength];
            this.offset = newMinIndex;
            this.minIndex = newMinIndex;
            this.maxIndex = newMinIndex;
            this.adjust(newMinIndex, newMaxIndex);
        } else if (newMinIndex >= this.offset && newMaxIndex < this.offset + this.counts.length) {
            this.minIndex = newMinIndex;
            this.maxIndex = newMaxIndex;
        } else {
            int desiredLength = newMaxIndex - newMinIndex + 1;
            int newLength = this.getNewLength(desiredLength);
            if (newLength > this.counts.length) {
                this.counts = Arrays.copyOf(this.counts, newLength);
            }
            this.adjust(newMinIndex, newMaxIndex);
        }
    }

    void shiftCounts(int shift) {
        int minArrayIndex = this.minIndex - this.offset;
        int maxArrayIndex = this.maxIndex - this.offset;
        System.arraycopy(this.counts, minArrayIndex, this.counts, minArrayIndex + shift, maxArrayIndex - minArrayIndex + 1);
        if (shift > 0) {
            Arrays.fill(this.counts, minArrayIndex, minArrayIndex + shift, 0L);
        } else {
            Arrays.fill(this.counts, maxArrayIndex + 1 + shift, maxArrayIndex + 1, 0L);
        }
        this.offset -= shift;
    }

    void centerCounts(int newMinIndex, int newMaxIndex) {
        int middleIndex = newMinIndex + (newMaxIndex - newMinIndex + 1) / 2;
        this.shiftCounts(this.offset + this.counts.length / 2 - middleIndex);
        this.minIndex = newMinIndex;
        this.maxIndex = newMaxIndex;
    }

    void resetCounts() {
        this.resetCounts(this.minIndex, this.maxIndex);
    }

    void resetCounts(int fromIndex, int toIndex) {
        Arrays.fill(this.counts, fromIndex - this.offset, toIndex - this.offset + 1, 0L);
    }

    @Override
    public boolean isEmpty() {
        return this.maxIndex < this.minIndex;
    }

    @Override
    public int getMinIndex() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.minIndex;
    }

    @Override
    public int getMaxIndex() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.maxIndex;
    }

    int getNewLength(int desiredLength) {
        return ((desiredLength + this.arrayLengthOverhead - 1) / this.arrayLengthGrowthIncrement + 1) * this.arrayLengthGrowthIncrement;
    }

    @Override
    public long getTotalCount() {
        return this.getTotalCount(this.minIndex, this.maxIndex);
    }

    long getTotalCount(int fromIndex, int toIndex) {
        if (this.isEmpty()) {
            return 0L;
        }
        int fromArrayIndex = Math.max(fromIndex - this.offset, 0);
        int toArrayIndex = Math.min(toIndex - this.offset, this.counts.length - 1);
        long totalCount = 0L;
        for (int arrayIndex = fromArrayIndex; arrayIndex <= toArrayIndex; ++arrayIndex) {
            totalCount += this.counts[arrayIndex];
        }
        return totalCount;
    }

    @Override
    public Stream<Bin> getAscendingStream() {
        if (this.isEmpty()) {
            return Stream.of(new Bin[0]);
        }
        return IntStream.range(0, this.counts.length).mapToObj(index -> new Bin(index + this.offset, this.counts[index]));
    }

    @Override
    public Stream<Bin> getDescendingStream() {
        if (this.isEmpty()) {
            return Stream.of(new Bin[0]);
        }
        return IntStream.iterate(this.counts.length - 1, index -> index - 1).limit(this.counts.length).mapToObj(index -> new Bin(index + this.offset, this.counts[index]));
    }

    @Override
    public Iterator<Bin> getAscendingIterator() {
        return new Iterator<Bin>(){
            private int index;
            {
                this.index = DenseStore.this.minIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index <= DenseStore.this.maxIndex;
            }

            @Override
            public Bin next() {
                return new Bin(this.index, DenseStore.this.counts[this.index++ - DenseStore.this.offset]);
            }
        };
    }

    @Override
    public Iterator<Bin> getDescendingIterator() {
        return new Iterator<Bin>(){
            private int index;
            {
                this.index = DenseStore.this.maxIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index >= DenseStore.this.minIndex;
            }

            @Override
            public Bin next() {
                return new Bin(this.index, DenseStore.this.counts[this.index-- - DenseStore.this.offset]);
            }
        };
    }
}

