/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.mapping.DoubleBitOperationHelper;
import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import java.util.Objects;

public class CubicallyInterpolatedMapping
implements IndexMapping {
    private static final double A = 0.17142857142857143;
    private static final double B = -0.6;
    private static final double C = 1.4285714285714286;
    private final double relativeAccuracy;
    private final double multiplier;

    public CubicallyInterpolatedMapping(double relativeAccuracy) {
        if (relativeAccuracy <= 0.0 || relativeAccuracy >= 1.0) {
            throw new IllegalArgumentException("The relative accuracy must be between 0 and 1.");
        }
        this.relativeAccuracy = relativeAccuracy;
        this.multiplier = 7.0 / (10.0 * Math.log((1.0 + relativeAccuracy) / (1.0 - relativeAccuracy)));
    }

    @Override
    public int index(double value) {
        double e;
        long longBits = Double.doubleToRawLongBits(value);
        double s = DoubleBitOperationHelper.getSignificandPlusOne(longBits) - 1.0;
        double index = (((0.17142857142857143 * s + -0.6) * s + 1.4285714285714286) * s + (e = (double)DoubleBitOperationHelper.getExponent(longBits))) * this.multiplier;
        return index >= 0.0 ? (int)index : (int)index - 1;
    }

    @Override
    public double value(int index) {
        double normalizedIndex = (double)index / this.multiplier;
        long exponent = (long)Math.floor(normalizedIndex);
        double d0 = -0.37469387755102035;
        double d1 = 0.8904489795918369 - 0.7934693877551021 * (normalizedIndex - (double)exponent);
        double p = Math.cbrt((d1 - Math.sqrt(d1 * d1 - -0.2104213399518907)) / 2.0);
        double significandPlusOne = -(-0.6 + p + -0.37469387755102035 / p) / 0.5142857142857142 + 1.0;
        return DoubleBitOperationHelper.buildDouble(exponent, significandPlusOne) * (1.0 + this.relativeAccuracy);
    }

    @Override
    public double relativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double minIndexableValue() {
        return Math.max(Math.pow(2.0, -2.147483647E9 / this.multiplier + 1.0), Double.MIN_NORMAL * (1.0 + this.relativeAccuracy) / (1.0 - this.relativeAccuracy));
    }

    @Override
    public double maxIndexableValue() {
        return Math.min(Math.pow(2.0, 2.147483647E9 / this.multiplier - 1.0), Double.MAX_VALUE / (1.0 + this.relativeAccuracy));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Double.compare(this.relativeAccuracy, ((CubicallyInterpolatedMapping)o).relativeAccuracy) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.relativeAccuracy);
    }
}

