/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.gk;

import com.datadoghq.sketch.QuantileSketch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;

public class GKArray
implements QuantileSketch<GKArray> {
    private final double rankAccuracy;
    private ArrayList<Entry> entries;
    private final double[] incoming;
    private int incomingIndex;
    private long compressedCount;
    private double minValue;

    public GKArray(double rankAccuracy) {
        this.rankAccuracy = rankAccuracy;
        this.entries = new ArrayList();
        this.incoming = new double[(int)(1.0 / rankAccuracy) + 1];
        this.incomingIndex = 0;
        this.minValue = Double.MAX_VALUE;
        this.compressedCount = 0L;
    }

    private GKArray(GKArray sketch) {
        this.rankAccuracy = sketch.rankAccuracy;
        this.entries = new ArrayList<Entry>(sketch.entries);
        this.incoming = Arrays.copyOf(sketch.incoming, sketch.incoming.length);
        this.incomingIndex = sketch.incomingIndex;
        this.compressedCount = sketch.compressedCount;
        this.minValue = sketch.minValue;
    }

    public double getRankAccuracy() {
        return this.rankAccuracy;
    }

    @Override
    public void accept(double value) {
        this.incoming[this.incomingIndex++] = value;
        if (this.incomingIndex == this.incoming.length) {
            this.compress();
        }
    }

    @Override
    public void accept(double value, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        for (long i = 0L; i < count; ++i) {
            this.accept(value);
        }
    }

    @Override
    public void mergeWith(GKArray other) {
        if (this.rankAccuracy != other.rankAccuracy) {
            throw new IllegalArgumentException("The sketches are not mergeable because they do not use the same accuracy parameter.");
        }
        if (other.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.entries = new ArrayList<Entry>(other.entries);
            System.arraycopy(other.incoming, 0, this.incoming, 0, other.incomingIndex);
            this.incomingIndex = other.incomingIndex;
            this.compressedCount = other.compressedCount;
            this.minValue = other.minValue;
            return;
        }
        other.compressIfNecessary();
        long spread = (long)(other.rankAccuracy * (double)(other.compressedCount - 1L));
        ArrayList<Entry> incomingEntries = new ArrayList<Entry>(other.entries.size() + 1);
        long n = other.entries.get(0).g + other.entries.get(0).delta - spread - 1L;
        if (n > 0L) {
            incomingEntries.add(new Entry(other.minValue, n, 0L));
        } else {
            this.minValue = Math.min(this.minValue, other.minValue);
        }
        for (int i = 0; i < other.entries.size() - 1; ++i) {
            incomingEntries.add(new Entry(other.entries.get(i).v, other.entries.get(i + 1).g + other.entries.get(i + 1).delta - other.entries.get(i).delta, 0L));
        }
        incomingEntries.add(new Entry(other.entries.get(other.entries.size() - 1).v, spread + 1L, 0L));
        this.compress(incomingEntries, other.compressedCount);
    }

    @Override
    public GKArray copy() {
        return new GKArray(this);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty() && this.incomingIndex == 0;
    }

    @Override
    public long getCount() {
        if (this.incomingIndex > 0) {
            this.compress();
        }
        return this.compressedCount;
    }

    @Override
    public double getMinValue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.compressIfNecessary();
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.compressIfNecessary();
        return this.entries.get(this.entries.size() - 1).v;
    }

    @Override
    public double getValueAtQuantile(double quantile) {
        int i;
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException("The quantile must be between 0 and 1.");
        }
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.compressIfNecessary();
        if (quantile == 0.0) {
            return this.minValue;
        }
        long rank = (long)(quantile * (double)(this.compressedCount - 1L)) + 1L;
        long spread = (long)(this.rankAccuracy * (double)(this.compressedCount - 1L));
        long gSum = 0L;
        for (i = 0; i < this.entries.size() && (gSum += this.entries.get(i).g) + this.entries.get(i).delta <= rank + spread; ++i) {
        }
        if (i == 0) {
            return this.minValue;
        }
        return this.entries.get(i - 1).v;
    }

    @Override
    public double[] getValuesAtQuantiles(double[] quantiles) {
        return Arrays.stream(quantiles).map(this::getValueAtQuantile).toArray();
    }

    private void compressIfNecessary() {
        if (this.incomingIndex > 0) {
            this.compress();
        }
    }

    private void compress() {
        this.compress(new ArrayList<Entry>(), 0L);
    }

    private void compress(List<Entry> additionalEntries, long additionalCount) {
        for (int i = 0; i < this.incomingIndex; ++i) {
            additionalEntries.add(new Entry(this.incoming[i], 1L, 0L));
        }
        additionalEntries.sort(Comparator.comparingDouble(e -> ((Entry)e).v));
        this.compressedCount += additionalCount + (long)this.incomingIndex;
        if (!additionalEntries.isEmpty()) {
            this.minValue = Math.min(this.minValue, additionalEntries.get(0).v);
        }
        long removalThreshold = 2L * (long)(this.rankAccuracy * (double)(this.compressedCount - 1L));
        ArrayList<Entry> mergedEntries = new ArrayList<Entry>(this.entries.size() + additionalEntries.size() / 3);
        int i = 0;
        int j = 0;
        while (i < additionalEntries.size() || j < this.entries.size()) {
            Entry entry;
            if (i == additionalEntries.size()) {
                if (j + 1 < this.entries.size() && this.entries.get(j).g + this.entries.get(j + 1).g + this.entries.get(j + 1).delta <= removalThreshold) {
                    entry = this.entries.get(j + 1);
                    entry.g = entry.g + this.entries.get(j).g;
                } else {
                    mergedEntries.add(this.entries.get(j));
                }
                ++j;
                continue;
            }
            if (j == this.entries.size()) {
                if (i + 1 < additionalEntries.size() && additionalEntries.get(i).g + additionalEntries.get(i + 1).g + additionalEntries.get(i + 1).delta <= removalThreshold) {
                    entry = additionalEntries.get(i + 1);
                    entry.g = entry.g + additionalEntries.get(i).g;
                } else {
                    mergedEntries.add(additionalEntries.get(i));
                }
                ++i;
                continue;
            }
            if (additionalEntries.get(i).v < this.entries.get(j).v) {
                if (additionalEntries.get(i).g + this.entries.get(j).g + this.entries.get(j).delta <= removalThreshold) {
                    entry = this.entries.get(j);
                    entry.g = entry.g + additionalEntries.get(i).g;
                } else {
                    additionalEntries.get(i).delta = this.entries.get(j).g + this.entries.get(j).delta - additionalEntries.get(i).g;
                    mergedEntries.add(additionalEntries.get(i));
                }
                ++i;
                continue;
            }
            if (j + 1 < this.entries.size() && this.entries.get(j).g + this.entries.get(j + 1).g + this.entries.get(j + 1).delta <= removalThreshold) {
                entry = this.entries.get(j + 1);
                entry.g = entry.g + this.entries.get(j).g;
            } else {
                mergedEntries.add(this.entries.get(j));
            }
            ++j;
        }
        this.entries = mergedEntries;
        this.incomingIndex = 0;
    }

    private static class Entry {
        private final double v;
        private long g;
        private long delta;

        private Entry(double v, long g, long delta) {
            this.v = v;
            this.g = g;
            this.delta = delta;
        }
    }
}

