/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import java.util.Objects;

abstract class LogLikeIndexMapping
implements IndexMapping {
    private final double relativeAccuracy;
    private final double multiplier;
    private final double normalizedIndexOffset;

    LogLikeIndexMapping(double relativeAccuracy) {
        if (relativeAccuracy <= 0.0 || relativeAccuracy >= 1.0) {
            throw new IllegalArgumentException("The relative accuracy must be between 0 and 1.");
        }
        this.relativeAccuracy = relativeAccuracy;
        this.multiplier = this.correctingFactor() * Math.log(this.base()) / Math.log((1.0 + relativeAccuracy) / (1.0 - relativeAccuracy));
        this.normalizedIndexOffset = 0.0;
    }

    LogLikeIndexMapping(double gamma, double indexOffset) {
        if (gamma <= 1.0) {
            throw new IllegalArgumentException("gamma must be greater than 1.");
        }
        this.relativeAccuracy = 1.0 - 2.0 / (1.0 + Math.exp(this.correctingFactor() * Math.log(gamma)));
        this.multiplier = Math.log(this.base()) / Math.log(gamma);
        this.normalizedIndexOffset = indexOffset - this.log(1.0) * this.multiplier;
    }

    abstract double log(double var1);

    abstract double logInverse(double var1);

    abstract double base();

    abstract double correctingFactor();

    @Override
    public final int index(double value) {
        double index = this.log(value) * this.multiplier + this.normalizedIndexOffset;
        return index >= 0.0 ? (int)index : (int)index - 1;
    }

    @Override
    public final double value(int index) {
        return this.logInverse(((double)index - this.normalizedIndexOffset) / this.multiplier) * (1.0 + this.relativeAccuracy);
    }

    @Override
    public final double relativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double minIndexableValue() {
        return Math.max(Math.pow(this.base(), (-2.147483648E9 - this.normalizedIndexOffset) / this.multiplier - this.log(1.0) + 1.0), Double.MIN_NORMAL * (1.0 + this.relativeAccuracy) / (1.0 - this.relativeAccuracy));
    }

    @Override
    public double maxIndexableValue() {
        return Math.min(Math.pow(this.base(), (2.147483647E9 - this.normalizedIndexOffset) / this.multiplier - this.log(1.0) - 1.0), Double.MAX_VALUE / (1.0 + this.relativeAccuracy));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogLikeIndexMapping that = (LogLikeIndexMapping)o;
        return Double.compare(that.multiplier, this.multiplier) == 0 && Double.compare(that.normalizedIndexOffset, this.normalizedIndexOffset) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.multiplier, this.normalizedIndexOffset);
    }
}

