/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.mapping.DoubleBitOperationHelper;
import com.datadoghq.sketch.ddsketch.mapping.LogLikeIndexMapping;

public class QuadraticallyInterpolatedMapping
extends LogLikeIndexMapping {
    private static final double ONE_THIRD = 0.3333333333333333;

    public QuadraticallyInterpolatedMapping(double relativeAccuracy) {
        super(relativeAccuracy);
    }

    QuadraticallyInterpolatedMapping(double gamma, double indexOffset) {
        super(gamma, indexOffset);
    }

    @Override
    double log(double value) {
        long longBits = Double.doubleToRawLongBits(value);
        double s = DoubleBitOperationHelper.getSignificandPlusOne(longBits);
        double e = DoubleBitOperationHelper.getExponent(longBits);
        return e - (s - 5.0) * (s - 1.0) * 0.3333333333333333;
    }

    @Override
    double logInverse(double index) {
        long exponent = (long)Math.floor(index);
        double significandPlusOne = 3.0 - Math.sqrt(4.0 - 3.0 * (index - (double)exponent));
        return DoubleBitOperationHelper.buildDouble(exponent, significandPlusOne);
    }

    @Override
    double base() {
        return 2.0;
    }

    @Override
    double correctingFactor() {
        return 3.0 / (4.0 * Math.log(2.0));
    }
}

