/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.store;

import com.datadoghq.sketch.ddsketch.store.Bin;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Store {
    default public void add(int index) {
        this.add(index, 1L);
    }

    default public void add(int index, long count) {
        this.add(index, (double)count);
    }

    public void add(int var1, double var2);

    default public void add(Bin bin) {
        this.add(bin.getIndex(), bin.getCount());
    }

    default public void mergeWith(Store store) {
        store.getStream().forEach(this::add);
    }

    public Store copy();

    default public boolean isEmpty() {
        return this.getStream().mapToDouble(Bin::getCount).allMatch(count -> count == 0.0);
    }

    default public double getTotalCount() {
        return this.getStream().mapToDouble(Bin::getCount).sum();
    }

    default public int getMinIndex() {
        return this.getAscendingStream().filter(bin -> bin.getCount() > 0.0).findFirst().orElseThrow(NoSuchElementException::new).getIndex();
    }

    default public int getMaxIndex() {
        return this.getDescendingStream().filter(bin -> bin.getCount() > 0.0).findFirst().orElseThrow(NoSuchElementException::new).getIndex();
    }

    default public Stream<Bin> getStream() {
        return this.getAscendingStream();
    }

    default public Stream<Bin> getAscendingStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getAscendingIterator(), 0), false);
    }

    default public Stream<Bin> getDescendingStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getDescendingIterator(), 0), false);
    }

    public Iterator<Bin> getAscendingIterator();

    public Iterator<Bin> getDescendingIterator();
}

