/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch;

import com.datadoghq.sketch.QuantileSketch;
import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import com.datadoghq.sketch.ddsketch.proto.DDSketch;
import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.Store;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class SignedDDSketch
implements QuantileSketch<SignedDDSketch> {
    private final IndexMapping indexMapping;
    private final double minIndexedValue;
    private final double maxIndexedValue;
    private final Store negativeValueStore;
    private final Store positiveValueStore;
    private double zeroCount;

    private SignedDDSketch(IndexMapping indexMapping, Store negativeValueStore, Store positiveValueStore, double zeroCount, double minIndexedValue) {
        this.indexMapping = indexMapping;
        this.minIndexedValue = Math.max(minIndexedValue, indexMapping.minIndexableValue());
        this.maxIndexedValue = indexMapping.maxIndexableValue();
        this.negativeValueStore = negativeValueStore;
        this.positiveValueStore = positiveValueStore;
        this.zeroCount = zeroCount;
    }

    private SignedDDSketch(IndexMapping indexMapping, Store negativeValueStore, Store positiveValueStore, double zeroCount) {
        this(indexMapping, negativeValueStore, positiveValueStore, zeroCount, 0.0);
    }

    public SignedDDSketch(IndexMapping indexMapping, Supplier<Store> storeSupplier) {
        this(indexMapping, storeSupplier, storeSupplier, 0.0);
    }

    public SignedDDSketch(IndexMapping indexMapping, Supplier<Store> negativeValueStoreSupplier, Supplier<Store> positiveValueStoreSupplier) {
        this(indexMapping, negativeValueStoreSupplier.get(), positiveValueStoreSupplier.get(), 0.0);
    }

    public SignedDDSketch(IndexMapping indexMapping, Supplier<Store> negativeValueStoreSupplier, Supplier<Store> positiveValueStoreSupplier, double minIndexedValue) {
        this(indexMapping, negativeValueStoreSupplier.get(), positiveValueStoreSupplier.get(), 0.0, minIndexedValue);
    }

    private SignedDDSketch(SignedDDSketch sketch) {
        this.indexMapping = sketch.indexMapping;
        this.minIndexedValue = sketch.minIndexedValue;
        this.maxIndexedValue = sketch.maxIndexedValue;
        this.negativeValueStore = sketch.negativeValueStore.copy();
        this.positiveValueStore = sketch.positiveValueStore.copy();
        this.zeroCount = sketch.zeroCount;
    }

    public IndexMapping getIndexMapping() {
        return this.indexMapping;
    }

    public Store getNegativeValueStore() {
        return this.negativeValueStore;
    }

    public Store getPositiveValueStore() {
        return this.positiveValueStore;
    }

    @Override
    public void accept(double value) {
        this.checkValueTrackable(value);
        if (value > this.minIndexedValue) {
            this.positiveValueStore.add(this.indexMapping.index(value));
        } else if (value < -this.minIndexedValue) {
            this.negativeValueStore.add(this.indexMapping.index(-value));
        } else {
            this.zeroCount += 1.0;
        }
    }

    @Override
    public void accept(double value, long count) {
        this.accept(value, (double)count);
    }

    public void accept(double value, double count) {
        this.checkValueTrackable(value);
        if (count < 0.0) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        if (value > this.minIndexedValue) {
            this.positiveValueStore.add(this.indexMapping.index(value), count);
        } else if (value < -this.minIndexedValue) {
            this.negativeValueStore.add(this.indexMapping.index(-value), count);
        } else {
            this.zeroCount += count;
        }
    }

    private void checkValueTrackable(double value) {
        if (value < -this.maxIndexedValue || value > this.maxIndexedValue) {
            throw new IllegalArgumentException("The input value is outside the range that is tracked by the sketch.");
        }
    }

    @Override
    public void mergeWith(SignedDDSketch other) {
        if (!this.indexMapping.equals(other.indexMapping)) {
            throw new IllegalArgumentException("The sketches are not mergeable because they do not use the same index mappings.");
        }
        this.negativeValueStore.mergeWith(other.negativeValueStore);
        this.positiveValueStore.mergeWith(other.positiveValueStore);
        this.zeroCount += other.zeroCount;
    }

    @Override
    public SignedDDSketch copy() {
        return new SignedDDSketch(this);
    }

    @Override
    public boolean isEmpty() {
        return this.zeroCount == 0.0 && this.negativeValueStore.isEmpty() && this.positiveValueStore.isEmpty();
    }

    @Override
    public double getCount() {
        return this.zeroCount + this.negativeValueStore.getTotalCount() + this.positiveValueStore.getTotalCount();
    }

    @Override
    public double getMinValue() {
        if (!this.negativeValueStore.isEmpty()) {
            return -this.indexMapping.value(this.negativeValueStore.getMaxIndex());
        }
        if (this.zeroCount > 0.0) {
            return 0.0;
        }
        return this.indexMapping.value(this.positiveValueStore.getMinIndex());
    }

    @Override
    public double getMaxValue() {
        if (!this.positiveValueStore.isEmpty()) {
            return this.indexMapping.value(this.positiveValueStore.getMaxIndex());
        }
        if (this.zeroCount > 0.0) {
            return 0.0;
        }
        return -this.indexMapping.value(this.negativeValueStore.getMinIndex());
    }

    @Override
    public double getValueAtQuantile(double quantile) {
        return this.getValueAtQuantile(quantile, this.getCount());
    }

    @Override
    public double[] getValuesAtQuantiles(double[] quantiles) {
        double count = this.getCount();
        return Arrays.stream(quantiles).map(quantile -> this.getValueAtQuantile(quantile, count)).toArray();
    }

    private double getValueAtQuantile(double quantile, double count) {
        double d;
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException("The quantile must be between 0 and 1.");
        }
        if (count == 0.0) {
            throw new NoSuchElementException();
        }
        double rank = quantile * (count - 1.0);
        double n = 0.0;
        Iterator<Bin> negativeBinIterator = this.negativeValueStore.getDescendingIterator();
        while (negativeBinIterator.hasNext()) {
            double d2;
            Bin bin = negativeBinIterator.next();
            n += bin.getCount();
            if (!(d2 > rank)) continue;
            return -this.indexMapping.value(bin.getIndex());
        }
        n += this.zeroCount;
        if (d > rank) {
            return 0.0;
        }
        Iterator<Bin> positiveBinIterator = this.positiveValueStore.getAscendingIterator();
        while (positiveBinIterator.hasNext()) {
            double d3;
            Bin bin = positiveBinIterator.next();
            n += bin.getCount();
            if (!(d3 > rank)) continue;
            return this.indexMapping.value(bin.getIndex());
        }
        throw new NoSuchElementException();
    }

    public DDSketch toProto() {
        return DDSketch.newBuilder().setPositiveValues(this.positiveValueStore.toProto()).setNegativeValues(this.negativeValueStore.toProto()).setZeroCount(this.zeroCount).setMapping(this.indexMapping.toProto()).build();
    }

    public static SignedDDSketch fromProto(Supplier<? extends Store> storeSupplier, DDSketch proto) {
        return new SignedDDSketch(IndexMapping.fromProto(proto.getMapping()), Store.fromProto(storeSupplier, proto.getNegativeValues()), Store.fromProto(storeSupplier, proto.getPositiveValues()), proto.getZeroCount());
    }
}

