/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.store;

import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.Store;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;

public class SparseStore
implements Store {
    private final NavigableMap<Integer, Double> bins;

    public SparseStore() {
        this.bins = new TreeMap<Integer, Double>();
    }

    private SparseStore(SparseStore store) {
        this.bins = new TreeMap<Integer, Double>((SortedMap<Integer, Double>)store.bins);
    }

    @Override
    public void add(int index) {
        this.bins.merge(index, 1.0, Double::sum);
    }

    @Override
    public void add(int index, double count) {
        if (count < 0.0) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        if (count == 0.0) {
            return;
        }
        this.bins.merge(index, count, Double::sum);
    }

    @Override
    public void add(Bin bin) {
        if (bin.getCount() == 0.0) {
            return;
        }
        this.bins.merge(bin.getIndex(), bin.getCount(), Double::sum);
    }

    @Override
    public Store copy() {
        return new SparseStore(this);
    }

    @Override
    public int getMinIndex() {
        return (Integer)this.bins.firstKey();
    }

    @Override
    public int getMaxIndex() {
        return (Integer)this.bins.lastKey();
    }

    @Override
    public Iterator<Bin> getAscendingIterator() {
        return SparseStore.getBinIterator(this.bins);
    }

    @Override
    public Iterator<Bin> getDescendingIterator() {
        return SparseStore.getBinIterator(this.bins.descendingMap());
    }

    private static Iterator<Bin> getBinIterator(Map<Integer, Double> bins) {
        final Iterator<Map.Entry<Integer, Double>> iterator = bins.entrySet().iterator();
        return new Iterator<Bin>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Bin next() {
                Map.Entry nextEntry = (Map.Entry)iterator.next();
                return new Bin((Integer)nextEntry.getKey(), (Double)nextEntry.getValue());
            }
        };
    }
}

