/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

class DoubleBitOperationHelper {
    static final int SIGNIFICAND_WIDTH = 53;
    static final long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
    static final long EXPONENT_MASK = 0x7FF0000000000000L;
    static final int EXPONENT_SHIFT = 52;
    static final int EXPONENT_BIAS = 1023;
    private static final long ONE = 0x3FF0000000000000L;

    private DoubleBitOperationHelper() {
    }

    static long getExponent(long longBits) {
        return ((longBits & 0x7FF0000000000000L) >> 52) - 1023L;
    }

    static double getSignificandPlusOne(long longBits) {
        return Double.longBitsToDouble(longBits & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
    }

    static double buildDouble(long exponent, double significandPlusOne) {
        return Double.longBitsToDouble(exponent + 1023L << 52 & 0x7FF0000000000000L | Double.doubleToRawLongBits(significandPlusOne) & 0xFFFFFFFFFFFFFL);
    }
}

