/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.store;

import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.BinAcceptor;
import com.datadoghq.sketch.ddsketch.store.Store;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PaginatedStore
implements Store {
    private static final int GROWTH = 8;
    private static final int PAGE_SIZE = 128;
    private static final int PAGE_MASK = 127;
    private static final int PAGE_SHIFT = Integer.bitCount(127);
    private double[][] pages = null;
    private int minPageIndex;

    public PaginatedStore() {
        this(Integer.MAX_VALUE);
    }

    PaginatedStore(int minPageIndex) {
        this.minPageIndex = minPageIndex;
    }

    PaginatedStore(PaginatedStore store) {
        this(store.minPageIndex);
        this.pages = store.isEmpty() ? (double[][])null : PaginatedStore.deepCopy(store.pages);
    }

    @Override
    public boolean isEmpty() {
        return this.minPageIndex == Integer.MAX_VALUE;
    }

    @Override
    public int getMinIndex() {
        if (null != this.pages) {
            for (int i = 0; i < this.pages.length; ++i) {
                if (null == this.pages[i]) continue;
                for (int j = 0; j < this.pages[i].length; ++j) {
                    if (this.pages[i][j] == 0.0) continue;
                    return (i + this.minPageIndex << PAGE_SHIFT) + j;
                }
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public int getMaxIndex() {
        if (null != this.pages) {
            for (int i = this.pages.length - 1; i >= 0; --i) {
                if (null == this.pages[i]) continue;
                for (int j = this.pages[i].length - 1; j >= 0; --j) {
                    if (this.pages[i][j] == 0.0) continue;
                    return (i + this.minPageIndex << PAGE_SHIFT) + j;
                }
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void forEach(BinAcceptor acceptor) {
        if (this.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.pages.length; ++i) {
            double[] page = this.pages[i];
            if (null == page) continue;
            for (int j = 0; j < page.length; ++j) {
                if (page[j] == 0.0) continue;
                acceptor.accept((i + this.minPageIndex << PAGE_SHIFT) + j, page[j]);
            }
        }
    }

    @Override
    public double getTotalCount() {
        if (this.isEmpty()) {
            return 0.0;
        }
        double total = 0.0;
        for (double[] page : this.pages) {
            if (null == page) continue;
            for (double count : page) {
                total += count;
            }
        }
        return total;
    }

    @Override
    public void add(int index, double count) {
        if (count > 0.0) {
            int alignedIndex = this.alignedIndex(index);
            double[] page = this.getPage(alignedIndex >>> PAGE_SHIFT);
            int n = alignedIndex & 0x7F;
            page[n] = page[n] + count;
        }
    }

    private double[] getPage(int pageIndex) {
        double[] page = this.pages[pageIndex];
        if (null == page) {
            this.pages[pageIndex] = new double[128];
            page = this.pages[pageIndex];
        }
        return page;
    }

    private int alignedIndex(int index) {
        int pageIndex;
        int n = pageIndex = index < 0 ? ~(-index >>> PAGE_SHIFT) : index >>> PAGE_SHIFT;
        if (pageIndex < this.minPageIndex) {
            if (this.isEmpty()) {
                this.lazyInit(pageIndex);
            } else {
                this.shiftPagesRight(pageIndex);
            }
        } else if (pageIndex >= this.minPageIndex + this.pages.length - 1) {
            this.extendTo(pageIndex);
        }
        return index + (-this.minPageIndex << PAGE_SHIFT);
    }

    private void lazyInit(int pageIndex) {
        this.minPageIndex = pageIndex;
        if (null == this.pages) {
            this.pages = new double[8][];
        }
    }

    private void shiftPagesRight(int pageIndex) {
        int requiredExtension = this.minPageIndex - pageIndex;
        if (requiredExtension > 0) {
            boolean canShiftRight = true;
            for (int i = 0; i < requiredExtension && canShiftRight && i < this.pages.length; ++i) {
                canShiftRight = null == this.pages[this.pages.length - i - 1];
            }
            if (canShiftRight) {
                System.arraycopy(this.pages, 0, this.pages, requiredExtension, this.pages.length - requiredExtension);
            } else {
                double[][] newPages = new double[this.pages.length + PaginatedStore.aligned(requiredExtension)][];
                System.arraycopy(this.pages, 0, newPages, requiredExtension, this.pages.length);
                this.pages = newPages;
            }
            Arrays.fill((Object[])this.pages, 0, requiredExtension, null);
            this.minPageIndex = pageIndex;
        }
    }

    private void extendTo(int pageIndex) {
        this.pages = (double[][])Arrays.copyOf(this.pages, PaginatedStore.aligned(pageIndex - this.minPageIndex + 2));
    }

    @Override
    public void mergeWith(Store store) {
        if (store.isEmpty()) {
            return;
        }
        if (store instanceof PaginatedStore) {
            this.mergeWith((PaginatedStore)store);
        } else {
            store.forEach(this::add);
        }
    }

    private void mergeWith(PaginatedStore store) {
        if (this.isEmpty()) {
            this.pages = PaginatedStore.deepCopy(store.pages);
            this.minPageIndex = store.minPageIndex;
        } else {
            int min = this.minPageIndex;
            int max = this.minPageIndex + this.pages.length;
            int storeMin = store.minPageIndex;
            int storeMax = store.minPageIndex + store.pages.length;
            if (max < storeMin) {
                this.extendTo(storeMax);
                for (int i = 0; i < store.pages.length; ++i) {
                    double[] page = store.pages[i];
                    if (null == page) continue;
                    this.pages[i + storeMin - min] = Arrays.copyOf(page, page.length);
                }
            } else if (min > storeMax) {
                this.shiftPagesRight(storeMin);
                for (int i = 0; i < store.pages.length; ++i) {
                    double[] page = store.pages[i];
                    if (null == page) continue;
                    this.pages[i] = Arrays.copyOf(page, page.length);
                }
            } else if (min < storeMin) {
                if (storeMax > max) {
                    this.extendTo(storeMax);
                }
                for (int i = 0; i < store.pages.length; ++i) {
                    double[] page = store.pages[i];
                    if (null == page) continue;
                    double[] target = this.pages[i + storeMin - min];
                    if (null == target) {
                        this.pages[i + storeMin - min] = Arrays.copyOf(page, page.length);
                        continue;
                    }
                    for (int j = 0; j < page.length; ++j) {
                        int n = j;
                        target[n] = target[n] + page[j];
                    }
                }
            } else {
                if (min > storeMin) {
                    this.shiftPagesRight(storeMin);
                }
                if (storeMax > max) {
                    this.extendTo(storeMax);
                }
                for (int i = 0; i < store.pages.length; ++i) {
                    double[] page = store.pages[i];
                    if (null == page) continue;
                    double[] target = this.pages[i];
                    if (null == target) {
                        this.pages[i] = Arrays.copyOf(page, page.length);
                        continue;
                    }
                    for (int j = 0; j < page.length; ++j) {
                        int n = j;
                        target[n] = target[n] + page[j];
                    }
                }
            }
        }
    }

    @Override
    public Store copy() {
        return new PaginatedStore(this);
    }

    @Override
    public void clear() {
        if (null != this.pages) {
            for (double[] page : this.pages) {
                if (null == page) continue;
                Arrays.fill(page, 0.0);
            }
        }
        this.minPageIndex = Integer.MAX_VALUE;
    }

    @Override
    public Iterator<Bin> getAscendingIterator() {
        return new AscendingIterator();
    }

    @Override
    public Iterator<Bin> getDescendingIterator() {
        return new DescendingIterator();
    }

    private static int aligned(int required) {
        return required + 8 - 1 & 0xFFFFFFF8;
    }

    private static double[][] deepCopy(double[][] pages) {
        if (null != pages) {
            double[][] copy = new double[pages.length][];
            for (int i = 0; i < pages.length; ++i) {
                double[] page = pages[i];
                if (null == page) continue;
                copy[i] = Arrays.copyOf(page, page.length);
            }
            return copy;
        }
        return null;
    }

    private final class DescendingIterator
    implements Iterator<Bin> {
        int pageIndex = 0;
        int valueIndex = 127;
        double[] page = null;
        double previous = Double.NaN;

        private DescendingIterator() {
            if (null != PaginatedStore.this.pages) {
                for (int i = PaginatedStore.this.pages.length - 1; i >= 0; --i) {
                    if (PaginatedStore.this.pages[i] == null) continue;
                    this.page = PaginatedStore.this.pages[i];
                    this.pageIndex = i;
                    this.previous = this.previousInPage();
                    break;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return !Double.isNaN(this.previous);
        }

        @Override
        public Bin next() {
            double value = this.previous;
            int index = (this.pageIndex + PaginatedStore.this.minPageIndex << PAGE_SHIFT) + this.valueIndex;
            --this.valueIndex;
            this.previous = this.previousInPage();
            if (Double.isNaN(this.previous)) {
                for (int i = this.pageIndex - 1; i >= 0; --i) {
                    if (PaginatedStore.this.pages[i] == null) continue;
                    this.page = PaginatedStore.this.pages[i];
                    this.pageIndex = i;
                    this.valueIndex = this.page.length - 1;
                    this.previous = this.previousInPage();
                    break;
                }
            }
            return new Bin(index, value);
        }

        private double previousInPage() {
            for (int i = this.valueIndex; i >= 0; --i) {
                if (this.page[i] == 0.0) continue;
                this.valueIndex = i;
                return this.page[i];
            }
            return Double.NaN;
        }
    }

    private final class AscendingIterator
    implements Iterator<Bin> {
        int pageIndex = 0;
        int valueIndex = 0;
        double[] page = null;
        double next = Double.NaN;

        private AscendingIterator() {
            if (null != PaginatedStore.this.pages) {
                for (int i = 0; i < PaginatedStore.this.pages.length; ++i) {
                    if (PaginatedStore.this.pages[i] == null) continue;
                    this.page = PaginatedStore.this.pages[i];
                    this.pageIndex = i;
                    this.next = this.nextInPage();
                    break;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return !Double.isNaN(this.next);
        }

        @Override
        public Bin next() {
            double value = this.next;
            int index = (this.pageIndex + PaginatedStore.this.minPageIndex << PAGE_SHIFT) + this.valueIndex;
            ++this.valueIndex;
            this.next = this.nextInPage();
            if (Double.isNaN(this.next)) {
                for (int i = this.pageIndex + 1; i < PaginatedStore.this.pages.length; ++i) {
                    if (PaginatedStore.this.pages[i] == null) continue;
                    this.page = PaginatedStore.this.pages[i];
                    this.pageIndex = i;
                    this.valueIndex = 0;
                    this.next = this.nextInPage();
                    break;
                }
            }
            return new Bin(index, value);
        }

        private double nextInPage() {
            for (int i = this.valueIndex; i < this.page.length; ++i) {
                if (this.page[i] == 0.0) continue;
                this.valueIndex = i;
                return this.page[i];
            }
            return Double.NaN;
        }
    }
}

