/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch;

import com.datadoghq.sketch.QuantileSketch;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class WithExactSummaryStatistics<QS extends QuantileSketch<QS>>
implements QuantileSketch<WithExactSummaryStatistics<QS>> {
    private final QS sketch;
    private double count;
    private double sum;
    private double sumCompensation;
    private double simpleSum;
    private double min;
    private double max;

    public WithExactSummaryStatistics(Supplier<QS> sketchSupplier) {
        this.sketch = (QuantileSketch)sketchSupplier.get();
        this.count = 0.0;
        this.sum = 0.0;
        this.sumCompensation = 0.0;
        this.simpleSum = 0.0;
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }

    private WithExactSummaryStatistics(QS sketch, double count, double sum, double sumCompensation, double simpleSum, double min, double max) {
        this.sketch = sketch;
        this.count = count;
        this.sum = sum;
        this.sumCompensation = sumCompensation;
        this.simpleSum = simpleSum;
        this.min = min;
        this.max = max;
    }

    @Override
    public void accept(double value) {
        this.sketch.accept(value);
        this.count += 1.0;
        this.simpleSum += value;
        this.sumWithCompensation(value);
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
    }

    @Override
    public void accept(double value, double count) {
        this.sketch.accept(value, count);
        this.count += count;
        this.simpleSum += value * count;
        this.sumWithCompensation(value * count);
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
    }

    @Override
    public void mergeWith(WithExactSummaryStatistics<QS> other) {
        this.sketch.mergeWith(other.sketch);
        this.count += other.count;
        this.simpleSum += other.simpleSum;
        this.sumWithCompensation(other.sum);
        this.sumWithCompensation(other.sumCompensation);
        this.min = Math.min(this.min, other.min);
        this.max = Math.max(this.max, other.max);
    }

    private void sumWithCompensation(double value) {
        double tmp = value - this.sumCompensation;
        double velvel = this.sum + tmp;
        this.sumCompensation = velvel - this.sum - tmp;
        this.sum = velvel;
    }

    @Override
    public WithExactSummaryStatistics<QS> copy() {
        return new WithExactSummaryStatistics(this.sketch.copy(), this.count, this.sum, this.sumCompensation, this.simpleSum, this.min, this.max);
    }

    @Override
    public void clear() {
        this.sketch.clear();
        this.count = 0.0;
        this.sum = 0.0;
        this.sumCompensation = 0.0;
        this.simpleSum = 0.0;
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getCount() {
        return this.count;
    }

    @Override
    public double getSum() {
        double tmp = this.sum + this.sumCompensation;
        if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSum)) {
            return this.simpleSum;
        }
        return tmp;
    }

    @Override
    public double getMinValue() {
        if (this.count == 0.0) {
            throw new NoSuchElementException();
        }
        return this.min;
    }

    @Override
    public double getMaxValue() {
        if (this.count == 0.0) {
            throw new NoSuchElementException();
        }
        return this.max;
    }

    @Override
    public double getValueAtQuantile(double quantile) {
        return this.clamp(this.sketch.getValueAtQuantile(quantile));
    }

    @Override
    public double[] getValuesAtQuantiles(double[] quantiles) {
        double[] valuesAtQuantiles = this.sketch.getValuesAtQuantiles(quantiles);
        for (int i = 0; i < valuesAtQuantiles.length; ++i) {
            valuesAtQuantiles[i] = this.clamp(valuesAtQuantiles[i]);
        }
        return valuesAtQuantiles;
    }

    private double clamp(double value) {
        if (this.max < this.min) {
            throw new IllegalStateException();
        }
        return Math.max(Math.min(value, this.max), this.min);
    }
}

