/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch;

import com.datadoghq.sketch.QuantileSketch;
import com.datadoghq.sketch.ddsketch.DDSketches;
import com.datadoghq.sketch.ddsketch.Serializer;
import com.datadoghq.sketch.ddsketch.mapping.BitwiseLinearlyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import com.datadoghq.sketch.ddsketch.mapping.LogarithmicMapping;
import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.CollapsingHighestDenseStore;
import com.datadoghq.sketch.ddsketch.store.CollapsingLowestDenseStore;
import com.datadoghq.sketch.ddsketch.store.Store;
import com.datadoghq.sketch.ddsketch.store.UnboundedSizeDenseStore;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class DDSketch
implements QuantileSketch<DDSketch> {
    private final IndexMapping indexMapping;
    private final double minIndexedValue;
    private final double maxIndexedValue;
    private final Store negativeValueStore;
    private final Store positiveValueStore;
    private double zeroCount;

    private DDSketch(IndexMapping indexMapping, Store negativeValueStore, Store positiveValueStore, double zeroCount, double minIndexedValue) {
        this.indexMapping = indexMapping;
        this.minIndexedValue = Math.max(minIndexedValue, indexMapping.minIndexableValue());
        this.maxIndexedValue = indexMapping.maxIndexableValue();
        this.negativeValueStore = negativeValueStore;
        this.positiveValueStore = positiveValueStore;
        this.zeroCount = zeroCount;
    }

    DDSketch(IndexMapping indexMapping, Store negativeValueStore, Store positiveValueStore, double zeroCount) {
        this(indexMapping, negativeValueStore, positiveValueStore, zeroCount, 0.0);
    }

    public DDSketch(IndexMapping indexMapping, Supplier<Store> storeSupplier) {
        this(indexMapping, storeSupplier, storeSupplier, 0.0);
    }

    public DDSketch(IndexMapping indexMapping, Supplier<Store> negativeValueStoreSupplier, Supplier<Store> positiveValueStoreSupplier) {
        this(indexMapping, negativeValueStoreSupplier.get(), positiveValueStoreSupplier.get(), 0.0);
    }

    public DDSketch(IndexMapping indexMapping, Supplier<Store> negativeValueStoreSupplier, Supplier<Store> positiveValueStoreSupplier, double minIndexedValue) {
        this(indexMapping, negativeValueStoreSupplier.get(), positiveValueStoreSupplier.get(), 0.0, minIndexedValue);
    }

    public DDSketch(double relativeAccuracy) {
        this(new LogarithmicMapping(relativeAccuracy), UnboundedSizeDenseStore::new);
    }

    private DDSketch(DDSketch sketch) {
        this.indexMapping = sketch.indexMapping;
        this.minIndexedValue = sketch.minIndexedValue;
        this.maxIndexedValue = sketch.maxIndexedValue;
        this.negativeValueStore = sketch.negativeValueStore.copy();
        this.positiveValueStore = sketch.positiveValueStore.copy();
        this.zeroCount = sketch.zeroCount;
    }

    public IndexMapping getIndexMapping() {
        return this.indexMapping;
    }

    public Store getNegativeValueStore() {
        return this.negativeValueStore;
    }

    public Store getPositiveValueStore() {
        return this.positiveValueStore;
    }

    @Override
    public void accept(double value) {
        this.checkValueTrackable(value);
        if (value > this.minIndexedValue) {
            this.positiveValueStore.add(this.indexMapping.index(value));
        } else if (value < -this.minIndexedValue) {
            this.negativeValueStore.add(this.indexMapping.index(-value));
        } else {
            this.zeroCount += 1.0;
        }
    }

    @Override
    public void accept(double value, double count) {
        this.checkValueTrackable(value);
        if (count < 0.0) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        if (value > this.minIndexedValue) {
            this.positiveValueStore.add(this.indexMapping.index(value), count);
        } else if (value < -this.minIndexedValue) {
            this.negativeValueStore.add(this.indexMapping.index(-value), count);
        } else {
            this.zeroCount += count;
        }
    }

    private void checkValueTrackable(double value) {
        if (value < -this.maxIndexedValue || value > this.maxIndexedValue) {
            throw new IllegalArgumentException("The input value is outside the range that is tracked by the sketch.");
        }
    }

    @Override
    public void mergeWith(DDSketch other) {
        if (!this.indexMapping.equals(other.indexMapping)) {
            throw new IllegalArgumentException("The sketches are not mergeable because they do not use the same index mappings.");
        }
        this.negativeValueStore.mergeWith(other.negativeValueStore);
        this.positiveValueStore.mergeWith(other.positiveValueStore);
        this.zeroCount += other.zeroCount;
    }

    @Override
    public DDSketch copy() {
        return new DDSketch(this);
    }

    @Override
    public boolean isEmpty() {
        return this.zeroCount == 0.0 && this.negativeValueStore.isEmpty() && this.positiveValueStore.isEmpty();
    }

    @Override
    public void clear() {
        this.negativeValueStore.clear();
        this.positiveValueStore.clear();
        this.zeroCount = 0.0;
    }

    @Override
    public double getCount() {
        return this.zeroCount + this.negativeValueStore.getTotalCount() + this.positiveValueStore.getTotalCount();
    }

    @Override
    public double getSum() {
        double[] sum = new double[]{0.0};
        this.negativeValueStore.forEach((index, count) -> {
            sum[0] = sum[0] - this.indexMapping.value(index) * count;
        });
        this.positiveValueStore.forEach((index, count) -> {
            sum[0] = sum[0] + this.indexMapping.value(index) * count;
        });
        return sum[0];
    }

    @Override
    public double getMinValue() {
        if (!this.negativeValueStore.isEmpty()) {
            return -this.indexMapping.value(this.negativeValueStore.getMaxIndex());
        }
        if (this.zeroCount > 0.0) {
            return 0.0;
        }
        return this.indexMapping.value(this.positiveValueStore.getMinIndex());
    }

    @Override
    public double getMaxValue() {
        if (!this.positiveValueStore.isEmpty()) {
            return this.indexMapping.value(this.positiveValueStore.getMaxIndex());
        }
        if (this.zeroCount > 0.0) {
            return 0.0;
        }
        return -this.indexMapping.value(this.negativeValueStore.getMinIndex());
    }

    @Override
    public double getValueAtQuantile(double quantile) {
        return this.getValueAtQuantile(quantile, this.getCount());
    }

    @Override
    public double[] getValuesAtQuantiles(double[] quantiles) {
        double count = this.getCount();
        return Arrays.stream(quantiles).map(quantile -> this.getValueAtQuantile(quantile, count)).toArray();
    }

    private double getValueAtQuantile(double quantile, double count) {
        double d;
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException("The quantile must be between 0 and 1.");
        }
        if (count == 0.0) {
            throw new NoSuchElementException();
        }
        double rank = quantile * (count - 1.0);
        double n = 0.0;
        Iterator<Bin> negativeBinIterator = this.negativeValueStore.getDescendingIterator();
        while (negativeBinIterator.hasNext()) {
            double d2;
            Bin bin = negativeBinIterator.next();
            n += bin.getCount();
            if (!(d2 > rank)) continue;
            return -this.indexMapping.value(bin.getIndex());
        }
        n += this.zeroCount;
        if (d > rank) {
            return 0.0;
        }
        Iterator<Bin> positiveBinIterator = this.positiveValueStore.getAscendingIterator();
        while (positiveBinIterator.hasNext()) {
            double d3;
            Bin bin = positiveBinIterator.next();
            n += bin.getCount();
            if (!(d3 > rank)) continue;
            return this.indexMapping.value(bin.getIndex());
        }
        throw new NoSuchElementException();
    }

    public int serializedSize() {
        return Serializer.embeddedFieldSize(1, this.indexMapping.serializedSize()) + Serializer.embeddedFieldSize(2, this.positiveValueStore.serializedSize()) + Serializer.embeddedFieldSize(3, this.negativeValueStore.serializedSize()) + Serializer.doubleFieldSize(4, this.zeroCount);
    }

    public ByteBuffer serialize() {
        int indexMappingSize = this.indexMapping.serializedSize();
        int positiveValueStoreSize = this.positiveValueStore.serializedSize();
        int negativeValueStoreSize = this.negativeValueStore.serializedSize();
        int totalSize = Serializer.embeddedFieldSize(1, indexMappingSize) + Serializer.embeddedFieldSize(2, positiveValueStoreSize) + Serializer.embeddedFieldSize(3, negativeValueStoreSize) + Serializer.doubleFieldSize(4, this.zeroCount);
        Serializer serializer = new Serializer(totalSize);
        serializer.writeHeader(1, indexMappingSize);
        this.indexMapping.serialize(serializer);
        serializer.writeHeader(2, positiveValueStoreSize);
        this.positiveValueStore.serialize(serializer);
        serializer.writeHeader(3, negativeValueStoreSize);
        this.negativeValueStore.serialize(serializer);
        serializer.writeDouble(4, this.zeroCount);
        return serializer.getBuffer();
    }

    double getZeroCount() {
        return this.zeroCount;
    }

    @Deprecated
    public static DDSketch balanced(double relativeAccuracy) {
        return DDSketches.unboundedDense(relativeAccuracy);
    }

    @Deprecated
    public static DDSketch balancedCollapsingLowest(double relativeAccuracy, int maxNumBins) {
        return DDSketches.collapsingLowestDense(relativeAccuracy, maxNumBins);
    }

    @Deprecated
    public static DDSketch balancedCollapsingHighest(double relativeAccuracy, int maxNumBins) {
        return DDSketches.collapsingHighestDense(relativeAccuracy, maxNumBins);
    }

    @Deprecated
    public static DDSketch fast(double relativeAccuracy) {
        return new DDSketch(new BitwiseLinearlyInterpolatedMapping(relativeAccuracy), UnboundedSizeDenseStore::new);
    }

    @Deprecated
    public static DDSketch fastCollapsingLowest(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new BitwiseLinearlyInterpolatedMapping(relativeAccuracy), () -> new CollapsingLowestDenseStore(maxNumBins));
    }

    @Deprecated
    public static DDSketch fastCollapsingHighest(double relativeAccuracy, int maxNumBins) {
        return new DDSketch(new BitwiseLinearlyInterpolatedMapping(relativeAccuracy), () -> new CollapsingHighestDenseStore(maxNumBins));
    }

    @Deprecated
    public static DDSketch memoryOptimal(double relativeAccuracy) {
        return DDSketches.logarithmicUnboundedDense(relativeAccuracy);
    }

    @Deprecated
    public static DDSketch memoryOptimalCollapsingLowest(double relativeAccuracy, int maxNumBins) {
        return DDSketches.logarithmicCollapsingLowestDense(relativeAccuracy, maxNumBins);
    }

    @Deprecated
    public static DDSketch memoryOptimalCollapsingHighest(double relativeAccuracy, int maxNumBins) {
        return DDSketches.logarithmicCollapsingHighestDense(relativeAccuracy, maxNumBins);
    }
}

