/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.mapping.BitwiseLinearlyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.mapping.CubicallyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.mapping.IndexMapping;
import com.datadoghq.sketch.ddsketch.mapping.Interpolation;
import com.datadoghq.sketch.ddsketch.mapping.LinearlyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.mapping.LogLikeIndexMapping;
import com.datadoghq.sketch.ddsketch.mapping.LogarithmicMapping;
import com.datadoghq.sketch.ddsketch.mapping.QuadraticallyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.proto.IndexMapping;

public class IndexMappingProtoBinding {
    public static com.datadoghq.sketch.ddsketch.proto.IndexMapping toProto(IndexMapping indexMapping) {
        if (indexMapping instanceof LogLikeIndexMapping) {
            return IndexMappingProtoBinding.toProtoLogLike((LogLikeIndexMapping)indexMapping);
        }
        if (indexMapping instanceof BitwiseLinearlyInterpolatedMapping) {
            return IndexMappingProtoBinding.toProtoBitwiseLinear((BitwiseLinearlyInterpolatedMapping)indexMapping);
        }
        throw new IllegalArgumentException("Unknown indexmapping " + indexMapping.getClass());
    }

    private static com.datadoghq.sketch.ddsketch.proto.IndexMapping toProtoLogLike(LogLikeIndexMapping indexMapping) {
        return com.datadoghq.sketch.ddsketch.proto.IndexMapping.newBuilder().setGamma(indexMapping.gamma()).setIndexOffset(indexMapping.indexOffset()).setInterpolation(IndexMappingProtoBinding.interpolation(indexMapping.interpolation())).build();
    }

    private static com.datadoghq.sketch.ddsketch.proto.IndexMapping toProtoBitwiseLinear(BitwiseLinearlyInterpolatedMapping indexMapping) {
        return com.datadoghq.sketch.ddsketch.proto.IndexMapping.newBuilder().setGamma(indexMapping.gamma()).setInterpolation(IndexMapping.Interpolation.LINEAR).build();
    }

    public static LogLikeIndexMapping fromProto(com.datadoghq.sketch.ddsketch.proto.IndexMapping proto) {
        double gamma = proto.getGamma();
        double indexOffset = proto.getIndexOffset();
        switch (proto.getInterpolation()) {
            case NONE: {
                return new LogarithmicMapping(gamma, indexOffset);
            }
            case LINEAR: {
                return new LinearlyInterpolatedMapping(gamma, indexOffset);
            }
            case QUADRATIC: {
                return new QuadraticallyInterpolatedMapping(gamma, indexOffset);
            }
            case CUBIC: {
                return new CubicallyInterpolatedMapping(gamma, indexOffset);
            }
        }
        throw new IllegalArgumentException("unrecognized interpolation");
    }

    private static IndexMapping.Interpolation interpolation(Interpolation interpolation) {
        switch (interpolation) {
            case NONE: {
                return IndexMapping.Interpolation.NONE;
            }
            case LINEAR: {
                return IndexMapping.Interpolation.LINEAR;
            }
            case QUADRATIC: {
                return IndexMapping.Interpolation.QUADRATIC;
            }
            case CUBIC: {
                return IndexMapping.Interpolation.CUBIC;
            }
        }
        throw new IllegalArgumentException("unrecognized interpolation");
    }
}

