/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.store;

import com.datadoghq.sketch.ddsketch.Serializer;
import com.datadoghq.sketch.ddsketch.store.Bin;
import com.datadoghq.sketch.ddsketch.store.BinAcceptor;
import com.datadoghq.sketch.ddsketch.store.Store;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class DenseStore
implements Store {
    private static final int DEFAULT_ARRAY_LENGTH_GROWTH_INCREMENT = 64;
    private static final double DEFAULT_ARRAY_LENGTH_OVERHEAD_RATIO = 0.1;
    private final int arrayLengthGrowthIncrement;
    private final int arrayLengthOverhead;
    double[] counts;
    int offset;
    int minIndex;
    int maxIndex;

    DenseStore() {
        this(64);
    }

    DenseStore(int arrayLengthGrowthIncrement) {
        this(arrayLengthGrowthIncrement, (int)((double)arrayLengthGrowthIncrement * 0.1));
    }

    DenseStore(int arrayLengthGrowthIncrement, int arrayLengthOverhead) {
        if (arrayLengthGrowthIncrement <= 0 || arrayLengthOverhead < 0) {
            throw new IllegalArgumentException("The array growth parameters are not valid.");
        }
        this.arrayLengthGrowthIncrement = arrayLengthGrowthIncrement;
        this.arrayLengthOverhead = arrayLengthOverhead;
        this.counts = null;
        this.offset = 0;
        this.minIndex = Integer.MAX_VALUE;
        this.maxIndex = Integer.MIN_VALUE;
    }

    DenseStore(DenseStore store) {
        this.arrayLengthGrowthIncrement = store.arrayLengthGrowthIncrement;
        this.arrayLengthOverhead = store.arrayLengthOverhead;
        this.minIndex = store.minIndex;
        this.maxIndex = store.maxIndex;
        if (store.counts != null && !store.isEmpty()) {
            this.counts = Arrays.copyOfRange(store.counts, store.minIndex - store.offset, store.maxIndex - store.offset + 1);
            this.offset = store.minIndex;
        } else {
            this.offset = store.offset;
        }
    }

    @Override
    public void add(int index) {
        int arrayIndex;
        int n = arrayIndex = this.normalize(index);
        this.counts[n] = this.counts[n] + 1.0;
    }

    @Override
    public void add(int index, double count) {
        int arrayIndex;
        if (count < 0.0) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        if (count == 0.0) {
            return;
        }
        int n = arrayIndex = this.normalize(index);
        this.counts[n] = this.counts[n] + count;
    }

    @Override
    public void add(Bin bin) {
        int arrayIndex;
        if (bin.getCount() == 0.0) {
            return;
        }
        int n = arrayIndex = this.normalize(bin.getIndex());
        this.counts[n] = this.counts[n] + bin.getCount();
    }

    @Override
    public void clear() {
        if (null != this.counts) {
            Arrays.fill(this.counts, 0.0);
        }
        this.maxIndex = Integer.MIN_VALUE;
        this.minIndex = Integer.MAX_VALUE;
        this.offset = 0;
    }

    abstract int normalize(int var1);

    abstract void adjust(int var1, int var2);

    void extendRange(int index) {
        this.extendRange(index, index);
    }

    void extendRange(int newMinIndex, int newMaxIndex) {
        newMinIndex = Math.min(newMinIndex, this.minIndex);
        newMaxIndex = Math.max(newMaxIndex, this.maxIndex);
        if (this.isEmpty()) {
            int initialLength = Math.toIntExact(this.getNewLength(newMinIndex, newMaxIndex));
            if (null == this.counts || initialLength >= this.counts.length) {
                this.counts = new double[initialLength];
            }
            this.offset = newMinIndex;
            this.minIndex = newMinIndex;
            this.maxIndex = newMaxIndex;
            this.adjust(newMinIndex, newMaxIndex);
        } else if (newMinIndex >= this.offset && (long)newMaxIndex < (long)this.offset + (long)this.counts.length) {
            this.minIndex = newMinIndex;
            this.maxIndex = newMaxIndex;
        } else {
            int newLength = Math.toIntExact(this.getNewLength(newMinIndex, newMaxIndex));
            if (newLength > this.counts.length) {
                this.counts = Arrays.copyOf(this.counts, newLength);
            }
            this.adjust(newMinIndex, newMaxIndex);
        }
    }

    void shiftCounts(int shift) {
        int minArrayIndex = this.minIndex - this.offset;
        int maxArrayIndex = this.maxIndex - this.offset;
        System.arraycopy(this.counts, minArrayIndex, this.counts, minArrayIndex + shift, maxArrayIndex - minArrayIndex + 1);
        if (shift > 0) {
            Arrays.fill(this.counts, minArrayIndex, minArrayIndex + shift, 0.0);
        } else {
            Arrays.fill(this.counts, maxArrayIndex + 1 + shift, maxArrayIndex + 1, 0.0);
        }
        this.offset -= shift;
    }

    void centerCounts(int newMinIndex, int newMaxIndex) {
        int middleIndex = newMinIndex + (newMaxIndex - newMinIndex + 1) / 2;
        this.shiftCounts(this.offset + this.counts.length / 2 - middleIndex);
        this.minIndex = newMinIndex;
        this.maxIndex = newMaxIndex;
    }

    void resetCounts() {
        this.resetCounts(this.minIndex, this.maxIndex);
    }

    void resetCounts(int fromIndex, int toIndex) {
        Arrays.fill(this.counts, fromIndex - this.offset, toIndex - this.offset + 1, 0.0);
    }

    @Override
    public boolean isEmpty() {
        return this.maxIndex < this.minIndex;
    }

    @Override
    public int getMinIndex() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.minIndex;
    }

    @Override
    public int getMaxIndex() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.maxIndex;
    }

    long getNewLength(int newMinIndex, int newMaxIndex) {
        long desiredLength = (long)newMaxIndex - (long)newMinIndex + 1L;
        return ((desiredLength + (long)this.arrayLengthOverhead - 1L) / (long)this.arrayLengthGrowthIncrement + 1L) * (long)this.arrayLengthGrowthIncrement;
    }

    @Override
    public double getTotalCount() {
        return this.getTotalCount(this.minIndex, this.maxIndex);
    }

    double getTotalCount(int fromIndex, int toIndex) {
        if (this.isEmpty()) {
            return 0.0;
        }
        int fromArrayIndex = Math.max(fromIndex - this.offset, 0);
        int toArrayIndex = Math.min(toIndex - this.offset, this.counts.length - 1);
        double totalCount = 0.0;
        for (int arrayIndex = fromArrayIndex; arrayIndex <= toArrayIndex; ++arrayIndex) {
            totalCount += this.counts[arrayIndex];
        }
        return totalCount;
    }

    @Override
    public void forEach(BinAcceptor acceptor) {
        if (this.isEmpty()) {
            return;
        }
        for (int i = this.minIndex; i < this.maxIndex; ++i) {
            double value = this.counts[i - this.offset];
            if (value == 0.0) continue;
            acceptor.accept(i, value);
        }
        double lastCount = this.counts[this.maxIndex - this.offset];
        if (lastCount != 0.0) {
            acceptor.accept(this.maxIndex, lastCount);
        }
    }

    @Override
    public Stream<Bin> getAscendingStream() {
        if (this.isEmpty()) {
            return Stream.of(new Bin[0]);
        }
        return IntStream.rangeClosed(this.minIndex, this.maxIndex).filter(index -> this.counts[index - this.offset] > 0.0).mapToObj(index -> new Bin(index, this.counts[index - this.offset]));
    }

    @Override
    public Stream<Bin> getDescendingStream() {
        if (this.isEmpty()) {
            return Stream.of(new Bin[0]);
        }
        return IntStream.iterate(this.maxIndex, index -> index - 1).limit(this.maxIndex - this.minIndex + 1).filter(index -> this.counts[index - this.offset] > 0.0).mapToObj(index -> new Bin(index, this.counts[index - this.offset]));
    }

    @Override
    public Iterator<Bin> getAscendingIterator() {
        return new Iterator<Bin>(){
            private long index;
            {
                this.index = DenseStore.this.minIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index <= (long)DenseStore.this.maxIndex;
            }

            @Override
            public Bin next() {
                int nextIndex = (int)this.index;
                do {
                    ++this.index;
                } while (this.index <= (long)DenseStore.this.maxIndex && DenseStore.this.counts[(int)this.index - DenseStore.this.offset] == 0.0);
                return new Bin(nextIndex, DenseStore.this.counts[nextIndex - DenseStore.this.offset]);
            }
        };
    }

    @Override
    public Iterator<Bin> getDescendingIterator() {
        return new Iterator<Bin>(){
            private long index;
            {
                this.index = DenseStore.this.maxIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index >= (long)DenseStore.this.minIndex;
            }

            @Override
            public Bin next() {
                int nextIndex = (int)this.index;
                do {
                    --this.index;
                } while (this.index >= (long)DenseStore.this.minIndex && DenseStore.this.counts[(int)this.index - DenseStore.this.offset] == 0.0);
                return new Bin(nextIndex, DenseStore.this.counts[nextIndex - DenseStore.this.offset]);
            }
        };
    }

    @Override
    public int serializedSize() {
        if (!this.isEmpty()) {
            return Serializer.sizeOfCompactDoubleArray(2, this.maxIndex - this.minIndex + 1) + Serializer.signedIntFieldSize(3, this.minIndex);
        }
        return 0;
    }

    @Override
    public void serialize(Serializer serializer) {
        if (!this.isEmpty()) {
            serializer.writeCompactArray(2, this.counts, this.minIndex - this.offset, this.maxIndex - this.minIndex + 1);
            serializer.writeSignedInt32(3, this.minIndex);
        }
    }
}

