/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.Serializer;
import com.datadoghq.sketch.ddsketch.encoding.IndexMappingLayout;
import com.datadoghq.sketch.ddsketch.encoding.Input;
import com.datadoghq.sketch.ddsketch.encoding.Output;
import com.datadoghq.sketch.ddsketch.mapping.CubicallyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.mapping.LinearlyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.mapping.LogarithmicMapping;
import com.datadoghq.sketch.ddsketch.mapping.QuadraticallyInterpolatedMapping;
import com.datadoghq.sketch.ddsketch.mapping.QuarticallyInterpolatedMapping;
import java.io.IOException;

public interface IndexMapping {
    public int index(double var1);

    public double value(int var1);

    public double lowerBound(int var1);

    public double upperBound(int var1);

    public double relativeAccuracy();

    public double minIndexableValue();

    public double maxIndexableValue();

    public void encode(Output var1) throws IOException;

    public static IndexMapping decode(Input input, IndexMappingLayout layout) throws IOException {
        double gamma = input.readDoubleLE();
        double indexOffset = input.readDoubleLE();
        switch (layout) {
            case LOG: {
                return new LogarithmicMapping(gamma, indexOffset);
            }
            case LOG_LINEAR: {
                return new LinearlyInterpolatedMapping(gamma, indexOffset);
            }
            case LOG_QUADRATIC: {
                return new QuadraticallyInterpolatedMapping(gamma, indexOffset);
            }
            case LOG_CUBIC: {
                return new CubicallyInterpolatedMapping(gamma, indexOffset);
            }
            case LOG_QUARTIC: {
                return new QuarticallyInterpolatedMapping(gamma, indexOffset);
            }
        }
        throw new IllegalStateException("The index mapping layout is not handled.");
    }

    public int serializedSize();

    public void serialize(Serializer var1);
}

