/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.encoding.IndexMappingLayout;
import com.datadoghq.sketch.ddsketch.mapping.DoubleBitOperationHelper;
import com.datadoghq.sketch.ddsketch.mapping.Interpolation;
import com.datadoghq.sketch.ddsketch.mapping.LogLikeIndexMapping;

public class LinearlyInterpolatedMapping
extends LogLikeIndexMapping {
    public LinearlyInterpolatedMapping(double relativeAccuracy) {
        super(relativeAccuracy);
    }

    LinearlyInterpolatedMapping(double gamma, double indexOffset) {
        super(gamma, indexOffset);
    }

    @Override
    double log(double value) {
        long longBits = Double.doubleToRawLongBits(value);
        return (double)DoubleBitOperationHelper.getExponent(longBits) + DoubleBitOperationHelper.getSignificandPlusOne(longBits);
    }

    @Override
    double logInverse(double index) {
        long exponent = (long)Math.floor(index - 1.0);
        double significandPlusOne = index - (double)exponent;
        return DoubleBitOperationHelper.buildDouble(exponent, significandPlusOne);
    }

    @Override
    double base() {
        return 2.0;
    }

    @Override
    double correctingFactor() {
        return 1.0 / Math.log(2.0);
    }

    @Override
    IndexMappingLayout layout() {
        return IndexMappingLayout.LOG_LINEAR;
    }

    @Override
    Interpolation interpolation() {
        return Interpolation.LINEAR;
    }
}

