/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.store;

import java.util.Objects;

public final class Bin {
    private final int index;
    private final double count;

    public Bin(int index, double count) {
        if (count < 0.0) {
            throw new IllegalArgumentException("The count cannot be negative.");
        }
        this.index = index;
        this.count = count;
    }

    public int getIndex() {
        return this.index;
    }

    public double getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bin bin = (Bin)o;
        return this.index == bin.index && Double.compare(bin.count, this.count) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.count);
    }

    public String toString() {
        return "Bin{index=" + this.index + ", count=" + this.count + '}';
    }
}

