/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.encoding.IndexMappingLayout;
import com.datadoghq.sketch.ddsketch.mapping.DoubleBitOperationHelper;
import com.datadoghq.sketch.ddsketch.mapping.Interpolation;
import com.datadoghq.sketch.ddsketch.mapping.LogLikeIndexMapping;

public class CubicallyInterpolatedMapping
extends LogLikeIndexMapping {
    private static final double A = 0.17142857142857143;
    private static final double B = -0.6;
    private static final double C = 1.4285714285714286;
    private static final double CORRECTING_FACTOR = 1.0 / (1.4285714285714286 * Math.log(2.0));

    public CubicallyInterpolatedMapping(double relativeAccuracy) {
        super(CubicallyInterpolatedMapping.gamma(CubicallyInterpolatedMapping.requireValidRelativeAccuracy(relativeAccuracy), CORRECTING_FACTOR), 0.0);
    }

    public CubicallyInterpolatedMapping(double gamma, double indexOffset) {
        super(gamma, indexOffset);
    }

    @Override
    double log(double value) {
        long longBits = Double.doubleToRawLongBits(value);
        double s = DoubleBitOperationHelper.getSignificandPlusOne(longBits) - 1.0;
        double e = DoubleBitOperationHelper.getExponent(longBits);
        return ((0.17142857142857143 * s + -0.6) * s + 1.4285714285714286) * s + e;
    }

    @Override
    double logInverse(double index) {
        long exponent = (long)Math.floor(index);
        double d0 = -0.37469387755102035;
        double d1 = 0.8904489795918369 - 0.7934693877551021 * (index - (double)exponent);
        double p = Math.cbrt((d1 - Math.sqrt(d1 * d1 - -0.2104213399518907)) / 2.0);
        double significandPlusOne = -(-0.6 + p + -0.37469387755102035 / p) / 0.5142857142857142 + 1.0;
        return DoubleBitOperationHelper.buildDouble(exponent, significandPlusOne);
    }

    @Override
    double base() {
        return 2.0;
    }

    @Override
    double correctingFactor() {
        return CORRECTING_FACTOR;
    }

    @Override
    IndexMappingLayout layout() {
        return IndexMappingLayout.LOG_CUBIC;
    }

    @Override
    Interpolation interpolation() {
        return Interpolation.CUBIC;
    }
}

