/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.encoding.IndexMappingLayout;
import com.datadoghq.sketch.ddsketch.mapping.DoubleBitOperationHelper;
import com.datadoghq.sketch.ddsketch.mapping.Interpolation;
import com.datadoghq.sketch.ddsketch.mapping.LogLikeIndexMapping;

public class LinearlyInterpolatedMapping
extends LogLikeIndexMapping {
    private static final double CORRECTING_FACTOR = 1.0 / Math.log(2.0);

    public LinearlyInterpolatedMapping(double relativeAccuracy) {
        super(LinearlyInterpolatedMapping.gamma(LinearlyInterpolatedMapping.requireValidRelativeAccuracy(relativeAccuracy), CORRECTING_FACTOR), LinearlyInterpolatedMapping.indexOffsetShift(relativeAccuracy));
    }

    public LinearlyInterpolatedMapping(double gamma, double indexOffset) {
        super(gamma, indexOffset);
    }

    private static double indexOffsetShift(double relativeAccuracy) {
        return 1.0 / Math.log1p(2.0 * relativeAccuracy / (1.0 - relativeAccuracy));
    }

    @Override
    double log(double value) {
        long longBits = Double.doubleToRawLongBits(value);
        return (double)DoubleBitOperationHelper.getExponent(longBits) + DoubleBitOperationHelper.getSignificandPlusOne(longBits) - 1.0;
    }

    @Override
    double logInverse(double index) {
        long exponent = (long)Math.floor(index);
        double significandPlusOne = index - (double)exponent + 1.0;
        return DoubleBitOperationHelper.buildDouble(exponent, significandPlusOne);
    }

    @Override
    double base() {
        return 2.0;
    }

    @Override
    double correctingFactor() {
        return CORRECTING_FACTOR;
    }

    @Override
    IndexMappingLayout layout() {
        return IndexMappingLayout.LOG_LINEAR;
    }

    @Override
    Interpolation interpolation() {
        return Interpolation.LINEAR;
    }
}

