/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.sketch.ddsketch.mapping;

import com.datadoghq.sketch.ddsketch.encoding.IndexMappingLayout;
import com.datadoghq.sketch.ddsketch.mapping.DoubleBitOperationHelper;
import com.datadoghq.sketch.ddsketch.mapping.Interpolation;
import com.datadoghq.sketch.ddsketch.mapping.LogLikeIndexMapping;

public class QuarticallyInterpolatedMapping
extends LogLikeIndexMapping {
    private static final double A = -0.08;
    private static final double B = 0.32;
    private static final double C = -0.68;
    private static final double D = 1.44;
    private static final double CORRECTING_FACTOR = 1.0 / (1.44 * Math.log(2.0));

    public QuarticallyInterpolatedMapping(double relativeAccuracy) {
        super(QuarticallyInterpolatedMapping.gamma(QuarticallyInterpolatedMapping.requireValidRelativeAccuracy(relativeAccuracy), CORRECTING_FACTOR), 0.0);
    }

    public QuarticallyInterpolatedMapping(double gamma, double indexOffset) {
        super(gamma, indexOffset);
    }

    @Override
    double log(double value) {
        long longBits = Double.doubleToRawLongBits(value);
        double s = DoubleBitOperationHelper.getSignificandPlusOne(longBits) - 1.0;
        double e = DoubleBitOperationHelper.getExponent(longBits);
        return (((-0.08 * s + 0.32) * s + -0.68) * s + 1.44) * s + e;
    }

    @Override
    double logInverse(double index) {
        double exponent = Math.floor(index);
        double e = exponent - index;
        double alpha = 2.500000000000001;
        double beta = -9.0;
        double gamma = -12.5 + e / -0.08;
        double p = -0.5208333333333337 - gamma;
        double q = -0.14467592592592607 + 2.500000000000001 * gamma / 3.0 - 10.125;
        double r = -q / 2.0 + Math.sqrt(q * q / 4.0 + p * p * p / 27.0);
        double u = Math.cbrt(r);
        double y = -2.083333333333334 + u - p / (3.0 * u);
        double w = Math.sqrt(2.500000000000001 + 2.0 * y);
        double x = 1.0 + (w - Math.sqrt(-(7.500000000000003 + 2.0 * y + -18.0 / w))) / 2.0;
        return DoubleBitOperationHelper.buildDouble((long)exponent, x + 1.0);
    }

    @Override
    double base() {
        return 2.0;
    }

    @Override
    double correctingFactor() {
        return CORRECTING_FACTOR;
    }

    @Override
    IndexMappingLayout layout() {
        return IndexMappingLayout.LOG_QUARTIC;
    }

    @Override
    Interpolation interpolation() {
        return Interpolation.QUARTIC;
    }
}

