/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter;

import com.dataliquid.asciidoc.linter.config.LinterConfiguration;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.rule.SectionConfig;
import com.dataliquid.asciidoc.linter.validator.BlockValidator;
import com.dataliquid.asciidoc.linter.validator.MetadataValidator;
import com.dataliquid.asciidoc.linter.validator.SectionValidator;
import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.ValidationResult;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;

public class Linter {
    private static final Logger logger = LogManager.getLogger(Linter.class);
    private final Asciidoctor asciidoctor = Asciidoctor.Factory.create();

    public ValidationResult validateFile(Path file, LinterConfiguration config) throws IOException {
        Objects.requireNonNull(file, "[" + this.getClass().getName() + "] file must not be null");
        Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IOException("File does not exist: " + String.valueOf(file));
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IOException("Not a regular file: " + String.valueOf(file));
        }
        return this.performValidation(file, config);
    }

    public Map<Path, ValidationResult> validateFiles(List<Path> files, LinterConfiguration config) {
        Objects.requireNonNull(files, "[" + this.getClass().getName() + "] files must not be null");
        Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        LinkedHashMap<Path, ValidationResult> results = new LinkedHashMap<Path, ValidationResult>();
        for (Path file : files) {
            try {
                ValidationResult result = this.validateFile(file, config);
                results.put(file, result);
            }
            catch (IOException e) {
                ValidationResult errorResult = this.createIOErrorResult(file, e);
                results.put(file, errorResult);
            }
        }
        return results;
    }

    public Map<Path, ValidationResult> validateDirectory(Path directory, String pattern, boolean recursive, LinterConfiguration config) throws IOException {
        Objects.requireNonNull(directory, "[" + this.getClass().getName() + "] directory must not be null");
        Objects.requireNonNull(pattern, "[" + this.getClass().getName() + "] pattern must not be null");
        Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IOException("Not a directory: " + String.valueOf(directory));
        }
        List<Path> files = this.findMatchingFiles(directory, pattern, recursive);
        return this.validateFiles(files, config);
    }

    public ValidationResult validateContent(String content, LinterConfiguration config) {
        Objects.requireNonNull(content, "[" + this.getClass().getName() + "] content must not be null");
        Objects.requireNonNull(config, "[" + this.getClass().getName() + "] config must not be null");
        Object filename = "inline-content";
        try {
            Options options = Options.builder().sourcemap(true).toFile(false).build();
            Document document = this.asciidoctor.load(content, options);
            if (document.getTitle() != null && !document.getTitle().isEmpty()) {
                filename = document.getTitle().replaceAll("[^a-zA-Z0-9-_]", "_").toLowerCase() + ".adoc";
            }
            return this.performValidation(document, (String)filename, config);
        }
        catch (Exception e) {
            return ValidationResult.builder().addScannedFile((String)filename).addMessage(this.createParseErrorMessage((String)filename, e)).complete().build();
        }
    }

    public void close() {
        if (this.asciidoctor != null) {
            this.asciidoctor.close();
        }
    }

    private ValidationResult performValidation(Path file, LinterConfiguration config) {
        try {
            Options options = Options.builder().sourcemap(true).toFile(false).build();
            Document document = this.asciidoctor.loadFile(file.toFile(), options);
            return this.performValidation(document, file.toString(), config);
        }
        catch (Exception e) {
            return ValidationResult.builder().addScannedFile(file.toString()).addMessage(this.createParseErrorMessage(file, e)).complete().build();
        }
    }

    private ValidationResult performValidation(Document document, String filename, LinterConfiguration config) {
        ValidationResult.Builder resultBuilder = ValidationResult.builder().addScannedFile(filename);
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (config.document() != null) {
            if (config.document().metadata() != null) {
                MetadataValidator metadataValidator = MetadataValidator.fromConfiguration(config.document().metadata()).build();
                ValidationResult metadataResult = metadataValidator.validate(document);
                messages.addAll(metadataResult.getMessages());
            }
            if (config.document().sections() != null) {
                SectionValidator sectionValidator = SectionValidator.builder().configuration(config.document()).build();
                ValidationResult sectionResult = sectionValidator.validate(document);
                messages.addAll(sectionResult.getMessages());
                messages.addAll(this.validateBlocks(document, config.document().sections(), filename));
            }
        }
        messages.forEach(resultBuilder::addMessage);
        return resultBuilder.complete().build();
    }

    private List<ValidationMessage> validateBlocks(Document document, List<SectionConfig> sectionConfigs, String filename) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        BlockValidator blockValidator = new BlockValidator();
        List<SectionConfig> level0Configs = this.extractLevel0Configs(sectionConfigs);
        List<SectionConfig> configsForLevel1Sections = this.determineConfigsForLevel1Sections(level0Configs, sectionConfigs);
        logger.debug("validateBlocks: level0Configs.size()={}, configsForLevel1Sections.size()={}", (Object)level0Configs.size(), (Object)configsForLevel1Sections.size());
        if (!level0Configs.isEmpty()) {
            this.validateDocumentLevelBlocks(document, level0Configs, blockValidator, filename, messages);
        }
        this.validateDocumentSections(document, configsForLevel1Sections, blockValidator, filename, messages);
        return messages;
    }

    private List<SectionConfig> extractLevel0Configs(List<SectionConfig> sectionConfigs) {
        return sectionConfigs.stream().filter(config -> config.level() == 0).collect(Collectors.toList());
    }

    private List<SectionConfig> determineConfigsForLevel1Sections(List<SectionConfig> level0Configs, List<SectionConfig> allConfigs) {
        for (SectionConfig level0Config : level0Configs) {
            if (level0Config.subsections() == null || level0Config.subsections().isEmpty()) continue;
            return level0Config.subsections();
        }
        return allConfigs.stream().filter(config -> config.level() != 0).collect(Collectors.toList());
    }

    private void validateDocumentLevelBlocks(Document document, List<SectionConfig> level0Configs, BlockValidator blockValidator, String filename, List<ValidationMessage> messages) {
        for (SectionConfig level0Config : level0Configs) {
            if (level0Config.allowedBlocks() == null || level0Config.allowedBlocks().isEmpty()) continue;
            ValidationResult blockResult = blockValidator.validate(document, level0Config, filename);
            messages.addAll(blockResult.getMessages());
        }
    }

    private void validateDocumentSections(Document document, List<SectionConfig> sectionConfigs, BlockValidator blockValidator, String filename, List<ValidationMessage> messages) {
        for (StructuralNode node : document.getBlocks()) {
            if (node instanceof Section) {
                Section section = (Section)node;
                this.validateSectionBlocks(section, sectionConfigs, blockValidator, filename, messages);
                continue;
            }
            logger.debug("validateDocumentSections: Skipping non-section node: context={}, nodeName={}", (Object)node.getContext(), (Object)node.getNodeName());
        }
    }

    private void validateSectionBlocks(Section section, List<SectionConfig> sectionConfigs, BlockValidator blockValidator, String filename, List<ValidationMessage> messages) {
        Optional<SectionConfig> matchingConfig = this.findMatchingSectionConfig(section, sectionConfigs);
        if (matchingConfig.isPresent()) {
            SectionConfig config = matchingConfig.get();
            this.validateSectionContent(section, config, blockValidator, filename, messages);
            List<SectionConfig> subsectionConfigs = this.determineSubsectionConfigs(config, sectionConfigs);
            this.processSubsections(section, subsectionConfigs, blockValidator, filename, messages);
        } else {
            this.processSubsections(section, sectionConfigs, blockValidator, filename, messages);
        }
    }

    private Optional<SectionConfig> findMatchingSectionConfig(Section section, List<SectionConfig> sectionConfigs) {
        return sectionConfigs.stream().filter(config -> config.level() != 0 && this.matchesSection(section, (SectionConfig)config)).findFirst();
    }

    private void validateSectionContent(Section section, SectionConfig config, BlockValidator blockValidator, String filename, List<ValidationMessage> messages) {
        ValidationResult blockResult = blockValidator.validate(section, config, filename);
        messages.addAll(blockResult.getMessages());
    }

    private List<SectionConfig> determineSubsectionConfigs(SectionConfig parentConfig, List<SectionConfig> fallbackConfigs) {
        if (parentConfig.subsections() != null && !parentConfig.subsections().isEmpty()) {
            return parentConfig.subsections();
        }
        return fallbackConfigs;
    }

    private void processSubsections(Section section, List<SectionConfig> subsectionConfigs, BlockValidator blockValidator, String filename, List<ValidationMessage> messages) {
        for (StructuralNode node : section.getBlocks()) {
            if (!(node instanceof Section)) continue;
            Section subsection = (Section)node;
            this.validateSectionBlocks(subsection, subsectionConfigs, blockValidator, filename, messages);
        }
    }

    private List<Path> findMatchingFiles(Path directory, String pattern, boolean recursive) throws IOException {
        final ArrayList<Path> matchingFiles = new ArrayList<Path>();
        final PathMatcher pathMatcher = directory.getFileSystem().getPathMatcher("glob:" + pattern);
        int maxDepth = recursive ? Integer.MAX_VALUE : 1;
        Files.walkFileTree(directory, new HashSet<FileVisitOption>(), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (pathMatcher.matches(file.getFileName())) {
                    matchingFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                logger.warn("Could not access file: {} ({})", (Object)file, (Object)exc.getMessage());
                return FileVisitResult.CONTINUE;
            }
        });
        return matchingFiles;
    }

    private boolean matchesSection(Section section, SectionConfig config) {
        if (config.level() != section.getLevel()) {
            return false;
        }
        if (config.title() != null) {
            String title = section.getTitle();
            if (title == null) {
                return false;
            }
            if (config.title().exactMatch() != null) {
                return title.equals(config.title().exactMatch());
            }
            if (config.title().pattern() != null) {
                return title.matches(config.title().pattern());
            }
        }
        return true;
    }

    private ValidationResult createIOErrorResult(Path file, IOException e) {
        return ValidationResult.builder().addScannedFile(file.toString()).addMessage(ValidationMessage.builder().severity(Severity.ERROR).ruleId("io-error").location(SourceLocation.builder().filename(file.toString()).startLine(1).build()).message("I/O error: " + e.getMessage()).cause(e).build()).complete().build();
    }

    private ValidationMessage createParseErrorMessage(Path file, Exception e) {
        return this.createParseErrorMessage(file.toString(), e);
    }

    private ValidationMessage createParseErrorMessage(String filename, Exception e) {
        return ValidationMessage.builder().severity(Severity.ERROR).ruleId("parse-error").location(SourceLocation.builder().filename(filename).startLine(1).build()).message("Failed to parse AsciiDoc file: " + e.getMessage()).cause(e).build();
    }
}

