/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.cli;

import com.dataliquid.asciidoc.linter.config.Severity;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;

public class CLIConfig {
    private final List<String> inputPatterns;
    private final Path baseDirectory;
    private final Path configFile;
    private final Path outputConfigFile;
    private final String reportFormat;
    private final Path reportOutput;
    private final Severity failLevel;

    private CLIConfig(Builder builder) {
        this.inputPatterns = Objects.requireNonNull(builder.inputPatterns, "[" + this.getClass().getName() + "] inputPatterns must not be null");
        if (this.inputPatterns.isEmpty()) {
            throw new IllegalArgumentException("inputPatterns must not be empty");
        }
        this.baseDirectory = Objects.requireNonNull(builder.baseDirectory, "[" + this.getClass().getName() + "] baseDirectory must not be null");
        this.configFile = builder.configFile;
        this.outputConfigFile = builder.outputConfigFile;
        this.reportFormat = Objects.requireNonNull(builder.reportFormat, "[" + this.getClass().getName() + "] reportFormat must not be null");
        this.reportOutput = builder.reportOutput;
        this.failLevel = Objects.requireNonNull(builder.failLevel, "[" + this.getClass().getName() + "] failLevel must not be null");
    }

    public List<String> getInputPatterns() {
        return this.inputPatterns;
    }

    public Path getBaseDirectory() {
        return this.baseDirectory;
    }

    public Path getConfigFile() {
        return this.configFile;
    }

    public Path getOutputConfigFile() {
        return this.outputConfigFile;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public Path getReportOutput() {
        return this.reportOutput;
    }

    public Severity getFailLevel() {
        return this.failLevel;
    }

    public boolean isOutputToFile() {
        return this.reportOutput != null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> inputPatterns;
        private Path baseDirectory = Paths.get(System.getProperty("user.dir"), new String[0]);
        private Path configFile;
        private Path outputConfigFile;
        private String reportFormat = "console";
        private Path reportOutput;
        private Severity failLevel = Severity.ERROR;

        public Builder inputPatterns(List<String> inputPatterns) {
            this.inputPatterns = inputPatterns;
            return this;
        }

        public Builder baseDirectory(Path baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        public Builder configFile(Path configFile) {
            this.configFile = configFile;
            return this;
        }

        public Builder outputConfigFile(Path outputConfigFile) {
            this.outputConfigFile = outputConfigFile;
            return this;
        }

        public Builder reportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        public Builder reportOutput(Path reportOutput) {
            this.reportOutput = reportOutput;
            return this;
        }

        public Builder failLevel(Severity failLevel) {
            this.failLevel = failLevel;
            return this;
        }

        public CLIConfig build() {
            return new CLIConfig(this);
        }
    }
}

