/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.cli;

import com.dataliquid.asciidoc.linter.cli.CLIConfig;
import com.dataliquid.asciidoc.linter.report.ReportWriter;
import com.dataliquid.asciidoc.linter.validator.ValidationResult;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class CLIOutputHandler {
    private final ReportWriter reportWriter = new ReportWriter();

    public void writeReport(ValidationResult result, CLIConfig config) throws IOException {
        if (config.isOutputToFile()) {
            Path outputFile = config.getReportOutput();
            this.ensureParentDirectoryExists(outputFile);
            try (PrintWriter writer = new PrintWriter(new FileWriter(outputFile.toFile()));){
                this.reportWriter.write(result, config.getReportFormat(), writer);
            }
        } else {
            this.reportWriter.writeToConsole(result, config.getReportFormat());
        }
    }

    public void writeMultipleReports(Map<Path, ValidationResult> results, CLIConfig config, ValidationResult aggregated) throws IOException {
        if (!config.isOutputToFile()) {
            this.reportWriter.writeToConsole(aggregated, config.getReportFormat());
            return;
        }
        Path output = config.getReportOutput();
        if (Files.isDirectory(output, new LinkOption[0]) || output.toString().endsWith("/") || output.toString().endsWith("\\")) {
            this.writeIndividualReports(results, config, output);
        } else {
            this.writeReport(aggregated, config);
        }
    }

    private void writeIndividualReports(Map<Path, ValidationResult> results, CLIConfig config, Path outputDir) throws IOException {
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        for (Map.Entry<Path, ValidationResult> entry : results.entrySet()) {
            Path inputFile = entry.getKey();
            ValidationResult result = entry.getValue();
            String outputFileName = this.generateOutputFileName(inputFile, config.getReportFormat());
            Path outputFile = outputDir.resolve(outputFileName);
            try (PrintWriter writer = new PrintWriter(new FileWriter(outputFile.toFile()));){
                this.reportWriter.write(result, config.getReportFormat(), writer);
            }
        }
    }

    private String generateOutputFileName(Path inputFile, String format) {
        String baseName = inputFile.getFileName().toString();
        if (baseName.endsWith(".adoc")) {
            baseName = baseName.substring(0, baseName.length() - 5);
        }
        String extension = "json".equals(format) ? ".json" : ".txt";
        return baseName + "-report" + extension;
    }

    private void ensureParentDirectoryExists(Path file) throws IOException {
        Path parent = file.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }
}

