/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.cli;

import com.dataliquid.asciidoc.linter.Linter;
import com.dataliquid.asciidoc.linter.cli.CLIConfig;
import com.dataliquid.asciidoc.linter.cli.CLIOutputHandler;
import com.dataliquid.asciidoc.linter.cli.FileDiscoveryService;
import com.dataliquid.asciidoc.linter.config.LinterConfiguration;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.loader.ConfigurationLoader;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.ValidationResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CLIRunner {
    private static final Logger logger = LogManager.getLogger(CLIRunner.class);
    private static final String DEFAULT_CONFIG_FILE = ".linter-config.yaml";
    private final FileDiscoveryService fileDiscoveryService = new FileDiscoveryService();
    private final CLIOutputHandler outputHandler = new CLIOutputHandler();
    private final ConfigurationLoader configurationLoader = new ConfigurationLoader();
    private final Linter linter = new Linter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(CLIConfig config) {
        try {
            LinterConfiguration linterConfig = this.loadLinterConfiguration(config);
            List<Path> filesToValidate = this.fileDiscoveryService.discoverFiles(config);
            if (filesToValidate.isEmpty()) {
                logger.error("No files found matching patterns: {}", (Object)String.join((CharSequence)", ", config.getInputPatterns()));
                int n = 2;
                return n;
            }
            if (filesToValidate.size() > 1) {
                logger.info("Validating {} files...", (Object)filesToValidate.size());
            }
            if (filesToValidate.size() == 1) {
                ValidationResult result = this.linter.validateFile(filesToValidate.get(0), linterConfig);
                this.outputHandler.writeReport(result, config);
                int n = this.determineExitCode(result, config.getFailLevel());
                return n;
            }
            Map<Path, ValidationResult> results = this.linter.validateFiles(filesToValidate, linterConfig);
            ValidationResult aggregated = this.aggregateResults(results);
            this.outputHandler.writeMultipleReports(results, config, aggregated);
            int n = this.determineExitCode(aggregated, config.getFailLevel());
            return n;
        }
        catch (IOException e) {
            logger.error("I/O error: {}", (Object)e.getMessage());
            int n = 2;
            return n;
        }
        catch (Exception e) {
            logger.error("Error: {}", (Object)e.getMessage(), (Object)e);
            int n = 2;
            return n;
        }
        finally {
            this.linter.close();
        }
    }

    private LinterConfiguration loadLinterConfiguration(CLIConfig config) throws IOException {
        Path configFile = config.getConfigFile();
        if (configFile == null) {
            Path defaultConfig = Paths.get(DEFAULT_CONFIG_FILE, new String[0]);
            if (Files.exists(defaultConfig, new LinkOption[0])) {
                configFile = defaultConfig;
            } else {
                return LinterConfiguration.builder().build();
            }
        }
        if (!Files.exists(configFile, new LinkOption[0])) {
            throw new IOException("Configuration file not found: " + String.valueOf(configFile));
        }
        return this.configurationLoader.loadConfiguration(configFile);
    }

    private int determineExitCode(ValidationResult result, Severity failLevel) {
        switch (failLevel) {
            case ERROR: {
                return result.hasErrors() ? 1 : 0;
            }
            case WARN: {
                return result.hasErrors() || result.hasWarnings() ? 1 : 0;
            }
            case INFO: {
                return result.hasMessages() ? 1 : 0;
            }
        }
        return 0;
    }

    private ValidationResult aggregateResults(Map<Path, ValidationResult> results) {
        ValidationResult.Builder aggregated = ValidationResult.builder();
        for (Map.Entry<Path, ValidationResult> entry : results.entrySet()) {
            aggregated.addScannedFiles(entry.getValue().getScannedFiles());
            for (ValidationMessage message : entry.getValue().getMessages()) {
                aggregated.addMessage(message);
            }
        }
        return aggregated.complete().build();
    }
}

