/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.cli;

import com.dataliquid.asciidoc.linter.config.LinterConfiguration;
import com.dataliquid.asciidoc.linter.config.loader.ConfigurationLoader;
import com.dataliquid.asciidoc.linter.documentation.AsciiDocRuleGenerator;
import com.dataliquid.asciidoc.linter.documentation.RuleDocumentationGenerator;
import com.dataliquid.asciidoc.linter.documentation.VisualizationStyle;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;

public class DocumentationGenerator {
    private final ConfigurationLoader configLoader = new ConfigurationLoader();

    public int run(CommandLine cmd) {
        try {
            String configPath = cmd.getOptionValue("config", ".linter-config.yaml");
            LinterConfiguration config = this.loadConfiguration(configPath);
            Set<VisualizationStyle> styles = this.parseVisualizationStyles(cmd.getOptionValue("viz-style"));
            AsciiDocRuleGenerator generator = new AsciiDocRuleGenerator(styles);
            String outputPath = cmd.getOptionValue("report-output");
            if (outputPath != null) {
                this.generateToFile(generator, config, outputPath);
                System.out.println("Documentation generated successfully: " + outputPath);
            } else {
                this.generateToStdout(generator, config);
            }
            return 0;
        }
        catch (Exception e) {
            System.err.println("Error generating documentation: " + e.getMessage());
            return 2;
        }
    }

    private LinterConfiguration loadConfiguration(String configPath) throws IOException {
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            throw new IOException("Configuration file not found: " + configPath);
        }
        return this.configLoader.loadConfiguration(configFile.toPath());
    }

    private Set<VisualizationStyle> parseVisualizationStyles(String stylesArg) {
        if (stylesArg == null || stylesArg.trim().isEmpty()) {
            return Set.of(VisualizationStyle.TREE);
        }
        return Arrays.stream(stylesArg.split(",")).map(String::trim).map(VisualizationStyle::fromName).collect(Collectors.toSet());
    }

    private void generateToFile(RuleDocumentationGenerator generator, LinterConfiguration config, String outputPath) throws IOException {
        File outputFile = new File(outputPath);
        File parentDir = outputFile.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Failed to create output directory: " + String.valueOf(parentDir));
        }
        try (PrintWriter writer = new PrintWriter(new FileWriter(outputFile));){
            generator.generate(config, writer);
        }
    }

    private void generateToStdout(RuleDocumentationGenerator generator, LinterConfiguration config) {
        PrintWriter writer = new PrintWriter(System.out);
        generator.generate(config, writer);
        writer.flush();
    }
}

