/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.cli;

import com.dataliquid.asciidoc.linter.cli.CLIConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileDiscoveryService {
    private static final Logger logger = LogManager.getLogger(FileDiscoveryService.class);

    public List<Path> discoverFiles(CLIConfig config) throws IOException {
        return this.discoverFiles(config.getInputPatterns(), config.getBaseDirectory());
    }

    public List<Path> discoverFiles(List<String> patterns, Path baseDir) throws IOException {
        LinkedHashSet<Path> matchedFiles = new LinkedHashSet<Path>();
        for (String pattern : patterns) {
            logger.debug("Processing pattern: {}", (Object)pattern);
            Path patternPath = Paths.get(pattern, new String[0]);
            if (patternPath.isAbsolute() && patternPath.toFile().exists() && patternPath.toFile().isFile()) {
                matchedFiles.add(patternPath.normalize());
                continue;
            }
            Path simpleFile = baseDir.resolve(pattern);
            if (simpleFile.toFile().isFile()) {
                matchedFiles.add(simpleFile.normalize());
                continue;
            }
            matchedFiles.addAll(this.findFilesMatchingAntPattern(pattern, baseDir));
        }
        return new ArrayList<Path>(matchedFiles);
    }

    private List<Path> findFilesMatchingAntPattern(String pattern, Path baseDir) throws IOException {
        ArrayList<Path> matchingFiles = new ArrayList<Path>();
        AntPatternFileFilter antFilter = new AntPatternFileFilter(pattern, baseDir);
        IOFileFilter dirFilter = TrueFileFilter.INSTANCE;
        File baseDirFile = baseDir.toFile();
        if (baseDirFile.exists() && baseDirFile.isDirectory()) {
            for (File file : FileUtils.listFiles((File)baseDirFile, (IOFileFilter)antFilter, (IOFileFilter)dirFilter)) {
                matchingFiles.add(file.toPath().normalize());
            }
        }
        return matchingFiles;
    }

    private static class AntPatternFileFilter
    implements IOFileFilter {
        private final String pattern;
        private final Path baseDir;

        public AntPatternFileFilter(String pattern, Path baseDir) {
            this.pattern = pattern;
            this.baseDir = baseDir;
        }

        public boolean accept(File file) {
            if (!file.isFile()) {
                return false;
            }
            Path filePath = file.toPath().normalize();
            Path relativePath = this.baseDir.relativize(filePath);
            String pathStr = relativePath.toString().replace(File.separatorChar, '/');
            return this.matchesAntPattern(pathStr, this.pattern);
        }

        public boolean accept(File dir, String name) {
            return this.accept(new File(dir, name));
        }

        private boolean matchesAntPattern(String path, String pattern) {
            boolean result = AntPatternMatcher.match(pattern, path);
            logger.debug("Matching '{}' against pattern '{}': {}", (Object)path, (Object)pattern, (Object)result);
            return result;
        }
    }

    private static class AntPatternMatcher {
        private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();

        private AntPatternMatcher() {
        }

        public static boolean match(String pattern, String path) {
            pattern = pattern.replace(File.separatorChar, '/');
            path = path.replace(File.separatorChar, '/');
            if (pattern.contains("**")) {
                return AntPatternMatcher.matchWithDoubleWildcard(pattern, path);
            }
            return AntPatternMatcher.matchSimplePattern(pattern, path);
        }

        private static boolean matchWithDoubleWildcard(String pattern, String path) {
            String[] patternParts = pattern.split("/");
            String[] pathParts = path.split("/");
            int patternIndex = 0;
            int pathIndex = 0;
            while (patternIndex < patternParts.length) {
                if (pathIndex >= pathParts.length) {
                    while (patternIndex < patternParts.length) {
                        if (!patternParts[patternIndex].equals("**")) {
                            return false;
                        }
                        ++patternIndex;
                    }
                    return true;
                }
                String patternPart = patternParts[patternIndex];
                if (patternPart.equals("**")) {
                    if (patternIndex == patternParts.length - 1) {
                        return true;
                    }
                    String nextPattern = patternParts[++patternIndex];
                    boolean found = false;
                    while (pathIndex < pathParts.length) {
                        if (AntPatternMatcher.matchPart(nextPattern, pathParts[pathIndex])) {
                            found = true;
                            ++pathIndex;
                            ++patternIndex;
                            break;
                        }
                        ++pathIndex;
                    }
                    if (found) continue;
                    return false;
                }
                if (pathIndex >= pathParts.length || !AntPatternMatcher.matchPart(patternPart, pathParts[pathIndex])) {
                    return false;
                }
                ++patternIndex;
                ++pathIndex;
            }
            return pathIndex == pathParts.length;
        }

        private static boolean matchSimplePattern(String pattern, String path) {
            String[] pathParts;
            String[] patternParts = pattern.split("/");
            if (patternParts.length != (pathParts = path.split("/")).length) {
                return false;
            }
            for (int i = 0; i < patternParts.length; ++i) {
                if (AntPatternMatcher.matchPart(patternParts[i], pathParts[i])) continue;
                return false;
            }
            return true;
        }

        private static boolean matchPart(String pattern, String text) {
            Pattern compiledPattern = PATTERN_CACHE.computeIfAbsent(pattern, p -> {
                StringBuilder regex = new StringBuilder("^");
                block5: for (int i = 0; i < p.length(); ++i) {
                    char c = p.charAt(i);
                    switch (c) {
                        case '*': {
                            regex.append(".*");
                            continue block5;
                        }
                        case '?': {
                            regex.append(".");
                            continue block5;
                        }
                        case '$': 
                        case '(': 
                        case ')': 
                        case '+': 
                        case '.': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            regex.append("\\").append(c);
                            continue block5;
                        }
                        default: {
                            regex.append(c);
                        }
                    }
                }
                regex.append("$");
                return Pattern.compile(regex.toString());
            });
            return compiledPattern.matcher(text).matches();
        }
    }
}

