/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.cli;

import com.dataliquid.asciidoc.linter.cli.CLIConfig;
import com.dataliquid.asciidoc.linter.cli.CLIOptions;
import com.dataliquid.asciidoc.linter.cli.CLIRunner;
import com.dataliquid.asciidoc.linter.cli.DocumentationGenerator;
import com.dataliquid.asciidoc.linter.config.Severity;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LinterCLI {
    private static final Logger logger = LogManager.getLogger(LinterCLI.class);
    private static final String VERSION = "0.1.0";
    private static final String PROGRAM_NAME = "asciidoc-linter";

    public static void main(String[] args) {
        LinterCLI cli = new LinterCLI();
        int exitCode = cli.run(args);
        System.exit(exitCode);
    }

    public int run(String[] args) {
        CLIOptions cliOptions = new CLIOptions();
        Options options = cliOptions.getOptions();
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("help")) {
                this.printHelp(options);
                return 0;
            }
            if (cmd.hasOption("version")) {
                this.printVersion();
                return 0;
            }
            if (cmd.hasOption("generate-docs")) {
                if (!cmd.hasOption("config")) {
                    System.err.println("Error: --config is required when using --generate-docs");
                    return 2;
                }
                DocumentationGenerator docGenerator = new DocumentationGenerator();
                return docGenerator.run(cmd);
            }
            if (!cmd.hasOption("input")) {
                System.err.println("Error: --input is required for validation");
                this.printHelp(options);
                return 2;
            }
            CLIConfig config = this.parseConfiguration(cmd);
            CLIRunner runner = new CLIRunner();
            return runner.run(config);
        }
        catch (ParseException e) {
            logger.error("Error: {}", (Object)e.getMessage());
            System.err.println("Error: " + e.getMessage());
            System.err.println();
            this.printHelp(options);
            return 2;
        }
        catch (IllegalArgumentException e) {
            logger.error("Error: {}", (Object)e.getMessage());
            System.err.println("Error: " + e.getMessage());
            return 2;
        }
    }

    private CLIConfig parseConfiguration(CommandLine cmd) {
        CLIConfig.Builder builder = CLIConfig.builder();
        String inputValue = cmd.getOptionValue("input");
        List<String> patterns = Arrays.stream(inputValue.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (patterns.isEmpty()) {
            throw new IllegalArgumentException("No input patterns provided");
        }
        builder.inputPatterns(patterns);
        if (cmd.hasOption("config")) {
            builder.configFile(Paths.get(cmd.getOptionValue("config"), new String[0]));
        }
        if (cmd.hasOption("output-config")) {
            builder.outputConfigFile(Paths.get(cmd.getOptionValue("output-config"), new String[0]));
        }
        if (cmd.hasOption("report-format")) {
            String format = cmd.getOptionValue("report-format");
            if (!(format.equals("console") || format.equals("json") || format.equals("json-compact"))) {
                throw new IllegalArgumentException("Invalid report format: " + format + ". Valid values are: console, json, json-compact");
            }
            builder.reportFormat(format);
        }
        if (cmd.hasOption("report-output")) {
            builder.reportOutput(Paths.get(cmd.getOptionValue("report-output"), new String[0]));
        }
        if (cmd.hasOption("fail-level")) {
            String level = cmd.getOptionValue("fail-level").toUpperCase();
            try {
                builder.failLevel(Severity.valueOf(level));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid fail level: " + level + ". Valid values are: error, warn, info");
            }
        }
        return builder.build();
    }

    private void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        String header = "\nValidates AsciiDoc files against configurable rules.\n\n";
        String footer = "\nExamples:\n  asciidoc-linter -i \"**/*.adoc\"\n  asciidoc-linter -i \"docs/**/*.adoc,examples/**/*.asciidoc\" -f json -o report.json\n  asciidoc-linter --input \"src/*/docs/**/*.adoc,README.adoc\" --config strict.yaml --fail-level warn\n  asciidoc-linter -i \"**/*.adoc\" --output-config enhanced-output.yaml\n\nAnt Pattern Syntax:\n  **  - matches any number of directories\n  *   - matches any number of characters (except /)\n  ?   - matches exactly one character\n\nExit codes:\n  0 - Success, no violations or only below fail level\n  1 - Violations at or above fail level found\n  2 - Invalid arguments or runtime error\n";
        formatter.printHelp("asciidoc-linter -i <patterns> [options]", header, options, footer, false);
    }

    private void printVersion() {
        System.out.println("asciidoc-linter version 0.1.0");
    }
}

