/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config;

import com.dataliquid.asciidoc.linter.config.MetadataConfiguration;
import com.dataliquid.asciidoc.linter.config.rule.SectionConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class DocumentConfiguration {
    private final MetadataConfiguration metadata;
    private final List<SectionConfig> sections;

    private DocumentConfiguration(Builder builder) {
        this.metadata = builder.metadata;
        this.sections = Collections.unmodifiableList(new ArrayList<SectionConfig>(builder.sections));
    }

    @JsonProperty(value="metadata")
    public MetadataConfiguration metadata() {
        return this.metadata;
    }

    @JsonProperty(value="sections")
    public List<SectionConfig> sections() {
        return this.sections;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentConfiguration that = (DocumentConfiguration)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.sections, that.sections);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.sections);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private MetadataConfiguration metadata;
        private List<SectionConfig> sections = new ArrayList<SectionConfig>();

        @JsonProperty(value="metadata")
        public Builder metadata(MetadataConfiguration metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="sections")
        public Builder sections(List<SectionConfig> sections) {
            this.sections = sections != null ? new ArrayList<SectionConfig>(sections) : new ArrayList();
            return this;
        }

        public Builder addSection(SectionConfig section) {
            this.sections.add(section);
            return this;
        }

        public DocumentConfiguration build() {
            return new DocumentConfiguration(this);
        }
    }
}

