/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config;

import com.dataliquid.asciidoc.linter.config.rule.AttributeConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class MetadataConfiguration {
    private final List<AttributeConfig> attributes;

    private MetadataConfiguration(Builder builder) {
        this.attributes = Collections.unmodifiableList(new ArrayList<AttributeConfig>(builder.attributes));
    }

    @JsonProperty(value="attributes")
    public List<AttributeConfig> attributes() {
        return this.attributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataConfiguration that = (MetadataConfiguration)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.attributes);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private List<AttributeConfig> attributes = new ArrayList<AttributeConfig>();

        @JsonProperty(value="attributes")
        public Builder attributes(List<AttributeConfig> attributes) {
            this.attributes = attributes != null ? new ArrayList<AttributeConfig>(attributes) : new ArrayList();
            return this;
        }

        public Builder addAttribute(AttributeConfig attribute) {
            this.attributes.add(attribute);
            return this;
        }

        public MetadataConfiguration build() {
            return new MetadataConfiguration(this);
        }
    }
}

