/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.config.rule.OccurrenceConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public abstract class AbstractBlock
implements Block {
    private final String name;
    private final Severity severity;
    private final OccurrenceConfig occurrence;
    private final Integer order;

    protected AbstractBlock(AbstractBuilder<?> builder) {
        this.name = builder.name;
        this.severity = builder.severity;
        this.occurrence = builder.occurrence;
        this.order = builder.order;
    }

    @Override
    public abstract BlockType getType();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public OccurrenceConfig getOccurrence() {
        return this.occurrence;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBlock that = (AbstractBlock)o;
        return Objects.equals(this.name, that.name) && this.severity == that.severity && Objects.equals(this.occurrence, that.occurrence) && Objects.equals(this.order, that.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.severity, this.occurrence, this.order});
    }

    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        protected String name;
        protected Severity severity;
        protected OccurrenceConfig occurrence;
        protected Integer order;

        protected AbstractBuilder() {
        }

        @JsonProperty(value="name")
        public T name(String name) {
            this.name = name;
            return (T)this;
        }

        @JsonProperty(value="severity")
        public T severity(Severity severity) {
            this.severity = severity;
            return (T)this;
        }

        @JsonProperty(value="occurrence")
        public T occurrence(OccurrenceConfig occurrence) {
            this.occurrence = occurrence;
            return (T)this;
        }

        @JsonProperty(value="order")
        public T order(Integer order) {
            this.order = order;
            return (T)this;
        }

        public abstract AbstractBlock build();
    }
}

