/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.config.blocks;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AbstractBlock;
import com.dataliquid.asciidoc.linter.config.rule.LineConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonDeserialize(builder=Builder.class)
public final class AdmonitionBlock
extends AbstractBlock {
    @JsonProperty(value="type")
    private final TypeConfig type;
    @JsonProperty(value="title")
    private final TitleConfig title;
    @JsonProperty(value="content")
    private final ContentConfig content;
    @JsonProperty(value="icon")
    private final IconConfig icon;

    private AdmonitionBlock(Builder builder) {
        super(builder);
        this.type = builder.type;
        this.title = builder.title;
        this.content = builder.content;
        this.icon = builder.icon;
    }

    @Override
    public BlockType getType() {
        return BlockType.ADMONITION;
    }

    public TypeConfig getTypeConfig() {
        return this.type;
    }

    public TitleConfig getTitle() {
        return this.title;
    }

    public ContentConfig getContent() {
        return this.content;
    }

    public IconConfig getIcon() {
        return this.icon;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdmonitionBlock)) {
            return false;
        }
        AdmonitionBlock that = (AdmonitionBlock)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.type, that.type) && Objects.equals(this.title, that.title) && Objects.equals(this.content, that.content) && Objects.equals(this.icon, that.icon);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.type, this.title, this.content, this.icon);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends AbstractBlock.AbstractBuilder<Builder> {
        private TypeConfig type;
        private TitleConfig title;
        private ContentConfig content;
        private IconConfig icon;

        public Builder type(TypeConfig type) {
            this.type = type;
            return this;
        }

        public Builder title(TitleConfig title) {
            this.title = title;
            return this;
        }

        public Builder content(ContentConfig content) {
            this.content = content;
            return this;
        }

        public Builder icon(IconConfig icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public AdmonitionBlock build() {
            Objects.requireNonNull(this.severity, "[" + this.getClass().getName() + "] severity is required");
            return new AdmonitionBlock(this);
        }
    }

    @JsonDeserialize(builder=TypeConfigBuilder.class)
    public static class TypeConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="allowed")
        private final List<String> allowed;
        @JsonProperty(value="severity")
        private final Severity severity;

        private TypeConfig(TypeConfigBuilder builder) {
            this.required = builder.required;
            this.allowed = builder.allowed != null ? Collections.unmodifiableList(new ArrayList<String>(builder.allowed)) : Collections.emptyList();
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public List<String> getAllowed() {
            return this.allowed;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static TypeConfigBuilder builder() {
            return new TypeConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypeConfig)) {
                return false;
            }
            TypeConfig that = (TypeConfig)o;
            return this.required == that.required && Objects.equals(this.allowed, that.allowed) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.allowed, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class TypeConfigBuilder {
            private boolean required;
            private List<String> allowed;
            private Severity severity;

            public TypeConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public TypeConfigBuilder allowed(List<String> allowed) {
                this.allowed = allowed;
                return this;
            }

            public TypeConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public TypeConfig build() {
                return new TypeConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=TitleConfigBuilder.class)
    public static class TitleConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="severity")
        private final Severity severity;

        private TitleConfig(TitleConfigBuilder builder) {
            this.required = builder.required;
            this.pattern = builder.pattern;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static TitleConfigBuilder builder() {
            return new TitleConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TitleConfig)) {
                return false;
            }
            TitleConfig that = (TitleConfig)o;
            return this.required == that.required && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern()) && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.pattern == null ? null : this.pattern.pattern(), this.minLength, this.maxLength, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class TitleConfigBuilder {
            private boolean required;
            private Pattern pattern;
            private Integer minLength;
            private Integer maxLength;
            private Severity severity;

            public TitleConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public TitleConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public TitleConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public TitleConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public TitleConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public TitleConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public TitleConfig build() {
                return new TitleConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=ContentConfigBuilder.class)
    public static class ContentConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="minLength")
        private final Integer minLength;
        @JsonProperty(value="maxLength")
        private final Integer maxLength;
        @JsonProperty(value="lines")
        private final LineConfig lines;
        @JsonProperty(value="severity")
        private final Severity severity;

        private ContentConfig(ContentConfigBuilder builder) {
            this.required = builder.required;
            this.minLength = builder.minLength;
            this.maxLength = builder.maxLength;
            this.lines = builder.lines;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Integer getMinLength() {
            return this.minLength;
        }

        public Integer getMaxLength() {
            return this.maxLength;
        }

        public LineConfig getLines() {
            return this.lines;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static ContentConfigBuilder builder() {
            return new ContentConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContentConfig)) {
                return false;
            }
            ContentConfig that = (ContentConfig)o;
            return this.required == that.required && Objects.equals(this.minLength, that.minLength) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.lines, that.lines) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.minLength, this.maxLength, this.lines, this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class ContentConfigBuilder {
            private boolean required;
            private Integer minLength;
            private Integer maxLength;
            private LineConfig lines;
            private Severity severity;

            public ContentConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public ContentConfigBuilder minLength(Integer minLength) {
                this.minLength = minLength;
                return this;
            }

            public ContentConfigBuilder maxLength(Integer maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public ContentConfigBuilder lines(LineConfig lines) {
                this.lines = lines;
                return this;
            }

            public ContentConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public ContentConfig build() {
                return new ContentConfig(this);
            }
        }
    }

    @JsonDeserialize(builder=IconConfigBuilder.class)
    public static class IconConfig {
        @JsonProperty(value="required")
        private final boolean required;
        @JsonProperty(value="pattern")
        private final Pattern pattern;
        @JsonProperty(value="severity")
        private final Severity severity;

        private IconConfig(IconConfigBuilder builder) {
            this.required = builder.required;
            this.pattern = builder.pattern;
            this.severity = builder.severity;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public static IconConfigBuilder builder() {
            return new IconConfigBuilder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IconConfig)) {
                return false;
            }
            IconConfig that = (IconConfig)o;
            return this.required == that.required && Objects.equals(this.pattern == null ? null : this.pattern.pattern(), that.pattern == null ? null : that.pattern.pattern()) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.required, this.pattern == null ? null : this.pattern.pattern(), this.severity});
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class IconConfigBuilder {
            private boolean required;
            private Pattern pattern;
            private Severity severity;

            public IconConfigBuilder required(boolean required) {
                this.required = required;
                return this;
            }

            public IconConfigBuilder pattern(Pattern pattern) {
                this.pattern = pattern;
                return this;
            }

            public IconConfigBuilder pattern(String pattern) {
                this.pattern = pattern != null ? Pattern.compile(pattern) : null;
                return this;
            }

            public IconConfigBuilder severity(Severity severity) {
                this.severity = severity;
                return this;
            }

            public IconConfig build() {
                return new IconConfig(this);
            }
        }
    }
}

